/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client;

import java.lang.reflect.Constructor;
import java.security.Principal;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.client.CIMClientXML;
import org.sblim.wbem.client.CIMOMHandle;
import org.sblim.wbem.util.SessionProperties;

public class CIMClientFactory {
    public static CIMOMHandle getClient(CIMNameSpace pNameSpace, Principal pPrincipal, Object pCredential, String pProtocol, SessionProperties pProperties) throws CIMException {
        CIMOMHandle client = null;
        try {
            Class<?> c = null;
            if (pProtocol.equals("CIM_XML")) {
                return new CIMClientXML(pNameSpace, pPrincipal, pCredential, pProtocol, pProperties != null ? pProperties : SessionProperties.getGlobalProperties());
            }
            c = Class.forName(pProtocol);
            if (c != null) {
                Constructor<?> constructor = c.getConstructor(CIMNameSpace.class, Principal.class, Object.class);
                client = (CIMOMHandle)constructor.newInstance(pNameSpace, pPrincipal, pCredential);
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", "CIMClient not found for the specified protocol(" + pProtocol + ")", e);
        }
        return client;
    }

    public static CIMOMHandle getClient(CIMNameSpace pNameSpace, Principal pPrincipal, Object pCredential, String pProtocol) throws CIMException {
        return CIMClientFactory.getClient(pNameSpace, pPrincipal, pCredential, pProtocol, null);
    }
}

