/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class FastTreeMap
extends TreeMap {
    protected TreeMap map = null;
    protected boolean fast = false;

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    public void clear() {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                treeMap.clear();
                this.map = treeMap;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.clear();
        }
    }

    public Object clone() {
        FastTreeMap fastTreeMap = null;
        if (this.fast) {
            fastTreeMap = new FastTreeMap((SortedMap)this.map);
        } else {
            TreeMap treeMap = this.map;
            synchronized (treeMap) {
                fastTreeMap = new FastTreeMap((SortedMap)this.map);
            }
        }
        fastTreeMap.setFast(this.getFast());
        return fastTreeMap;
    }

    public Comparator comparator() {
        if (this.fast) {
            return this.map.comparator();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.comparator();
        }
    }

    public boolean containsKey(Object object) {
        if (this.fast) {
            return this.map.containsKey(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.containsKey(object);
        }
    }

    public boolean containsValue(Object object) {
        if (this.fast) {
            return this.map.containsValue(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.containsValue(object);
        }
    }

    public Set entrySet() {
        if (this.fast) {
            return this.map.entrySet();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.entrySet();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.fast) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!(v == null ? map.get(k) != null || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
                return false;
            }
            return true;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) {
                    if (map.get(k) == null && map.containsKey(k)) continue;
                    return false;
                }
                if (v.equals(map.get(k))) continue;
                return false;
            }
            return true;
        }
    }

    public Object firstKey() {
        if (this.fast) {
            return this.map.firstKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.firstKey();
        }
    }

    public Object get(Object object) {
        if (this.fast) {
            return this.map.get(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.get(object);
        }
    }

    public int hashCode() {
        if (this.fast) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            return n;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            return n;
        }
    }

    public SortedMap headMap(Object object) {
        if (this.fast) {
            return this.map.headMap(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.headMap(object);
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.isEmpty();
        }
    }

    public Set keySet() {
        if (this.fast) {
            return this.map.keySet();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.keySet();
        }
    }

    public Object lastKey() {
        if (this.fast) {
            return this.map.lastKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.lastKey();
        }
    }

    public Object put(Object object, Object object2) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                Object object3 = treeMap.put(object, object2);
                this.map = treeMap;
                return object3;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.put(object, object2);
        }
    }

    public void putAll(Map map) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                treeMap.putAll(map);
                this.map = treeMap;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.putAll(map);
        }
    }

    public Object remove(Object object) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                Object v = treeMap.remove(object);
                this.map = treeMap;
                return v;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.remove(object);
        }
    }

    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.size();
        }
    }

    public SortedMap subMap(Object object, Object object2) {
        if (this.fast) {
            return this.map.subMap(object, object2);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.subMap(object, object2);
        }
    }

    public SortedMap tailMap(Object object) {
        if (this.fast) {
            return this.map.tailMap(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.tailMap(object);
        }
    }

    public Collection values() {
        if (this.fast) {
            return this.map.values();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.values();
        }
    }

    public FastTreeMap() {
        this.map = new TreeMap();
    }

    public FastTreeMap(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    public FastTreeMap(Map map) {
        this.map = new TreeMap(map);
    }

    public FastTreeMap(SortedMap sortedMap) {
        this.map = new TreeMap(sortedMap);
    }
}

