/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.multiplex;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class SymmetricScenarioClient {
    static int bindPort = 5555;
    static String connectHost = "localhost";
    static int connectPort = 6666;

    public void runSymmetricScenario() {
        try {
            Socket syncSocket = new Socket(connectHost, connectPort);
            InputStream is_sync = syncSocket.getInputStream();
            OutputStream os_sync = syncSocket.getOutputStream();
            VirtualServerSocket serverSocket = new VirtualServerSocket(bindPort);
            InetSocketAddress address1 = new InetSocketAddress(connectHost, connectPort + 1);
            is_sync.read();
            serverSocket.setSoTimeout(5000);
            serverSocket.connect(address1);
            os_sync.write(5);
            is_sync.read();
            int port = serverSocket.getRemotePort();
            VirtualSocket virtualSocket1 = new VirtualSocket(connectHost, port);
            InputStream is1 = ((Socket)virtualSocket1).getInputStream();
            OutputStream os1 = ((Socket)virtualSocket1).getOutputStream();
            Socket virtualSocket2 = serverSocket.accept();
            InputStream is2 = virtualSocket2.getInputStream();
            OutputStream os2 = virtualSocket2.getOutputStream();
            os1.write(9);
            System.out.println(is1.read());
            os2.write(11);
            System.out.println(is2.read());
            ((Socket)virtualSocket1).close();
            virtualSocket2.close();
            syncSocket.close();
            serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length == 3) {
            bindPort = Integer.parseInt(args[0]);
            connectHost = args[1];
            connectPort = Integer.parseInt(args[2]);
        }
        new SymmetricScenarioClient().runSymmetricScenario();
    }
}

