/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jms.delegate.DeliveryRecovery;
import org.jboss.jms.delegate.SessionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class SessionRecoverDeliveriesRequest
extends RequestSupport {
    private List dels;
    private String sessionID;

    public SessionRecoverDeliveriesRequest() {
    }

    public SessionRecoverDeliveriesRequest(String objectId, byte version, List dels, String sessionID) {
        super(objectId, 313, version);
        this.dels = dels;
        this.sessionID = sessionID;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        int size = is.readInt();
        this.dels = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            DeliveryRecovery del = new DeliveryRecovery();
            del.read(is);
            this.dels.add(del);
        }
        this.sessionID = is.readUTF();
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.recoverDeliveries(this.dels, this.sessionID);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeInt(this.dels.size());
        for (DeliveryRecovery del : this.dels) {
            del.write(os);
        }
        os.writeUTF(this.sessionID);
        os.flush();
    }
}

