/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresforest.Driver;
import org.postgresforest.core.BaseStatement;
import org.postgresforest.core.QueryExecutor;
import org.postgresforest.vm.AbstractForestConnection;
import org.postgresforest.vm.AbstractForestThread;
import org.postgresforest.vm.DistError;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.StatementSub;

public class StatementExecuteSub
extends AbstractForestThread {
    public static final int ERR_NONE = 0;
    public static final int ERR_BROKEN = -1;
    public static final int ERR_NOT_BROKEN = -2;
    public static final int ERR_TIMEOUT = -3;
    public static final int ERR_ROLLBACK = -4;
    protected Statement m_st;
    protected String[] m_sqlFragments;
    protected Object[] m_binds = new Object[0];
    protected StatementSub m_obj;
    protected int m_ErrCode;
    protected SQLException m_errobj;

    public StatementExecuteSub(LogUtil logUtil) {
        super(logUtil);
    }

    public void execute(AbstractForestConnection srccon, String[] srcSql, Object[] srcBinds, StatementSub srcobj) throws SQLException {
        this.m_st = srccon.createStatement();
        this.m_sqlFragments = srcSql;
        this.m_binds = srcBinds;
        this.m_obj = srcobj;
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _execute() {
        block22: {
            StatementSub statementSub;
            try {
                try {
                    this.m_ErrCode = -3;
                    this.m_errobj = null;
                    this.m_obj.m_res = (ResultSet)((Object)QueryExecutor.execute(this.m_sqlFragments, this.m_binds, (BaseStatement)((Object)this.m_st)));
                    if (Driver.logInfo) {
                        this.m_logUtil.info(this.getName() + ": Execution of a query was completed. (" + this.m_sqlFragments[0] + ")");
                    }
                    this.m_ErrCode = 0;
                }
                catch (SQLException esql) {
                    if (Driver.logInfo) {
                        this.m_logUtil.info(this.getName() + ": Query execution error = ", esql);
                    }
                    if (DistError.isRollBack(esql)) {
                        if (Driver.logInfo) {
                            this.m_logUtil.info(this.getName() + ": RollBack!!", esql);
                        }
                        this.m_ErrCode = -4;
                        this.m_errobj = esql;
                        Object var4_2 = null;
                        if (this.m_obj != null) {
                            StatementSub statementSub3 = this.m_obj;
                            synchronized (statementSub3) {
                                this.m_obj.notify();
                                return;
                            }
                        }
                        if (Driver.logDebug) {
                            this.m_logUtil.debug(this.getName() + ":_execute End(not notify)");
                        }
                        return;
                    }
                    boolean isErr = DistError.isBroken(esql);
                    this.m_ErrCode = isErr ? -1 : -2;
                    this.m_errobj = esql;
                    Object var4_3 = null;
                    if (this.m_obj == null) {
                        if (Driver.logDebug) {
                            this.m_logUtil.debug(this.getName() + ":_execute End(not notify)");
                        }
                        return;
                    }
                    StatementSub statementSub4 = this.m_obj;
                    synchronized (statementSub4) {
                        this.m_obj.notify();
                        break block22;
                    }
                }
                Object var4_1 = null;
                if (this.m_obj == null) {
                    if (Driver.logDebug) {
                        this.m_logUtil.debug(this.getName() + ":_execute End(not notify)");
                    }
                    return;
                }
                statementSub = this.m_obj;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.m_obj != null) {
                    StatementSub statementSub2 = this.m_obj;
                    synchronized (statementSub2) {
                        this.m_obj.notify();
                        throw throwable;
                    }
                }
                if (Driver.logDebug) {
                    this.m_logUtil.debug(this.getName() + ":_execute End(not notify)");
                }
                return;
            }
            synchronized (statementSub) {
                this.m_obj.notify();
            }
        }
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ":_execute End");
        }
    }

    public SQLException getErrobj() {
        return this.m_errobj;
    }

    public int getErrCode() {
        return this.m_ErrCode;
    }

    public synchronized void terminate() {
        this.m_obj = null;
        this.m_runnning = false;
        this.interrupt();
        try {
            this.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isAlive()) {
            this.stop();
        }
    }
}

