/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.jdbc2;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;

public class TimestampUtils {
    private StringBuffer sbuf = new StringBuffer();
    private Calendar defaultCal = new GregorianCalendar();
    private Calendar calCache;
    private int calCacheZone;
    private boolean min74;

    TimestampUtils(boolean min74) {
        this.min74 = min74;
    }

    private Calendar getCalendar(int sign, int hr, int min) {
        int unified = sign * (hr * 100 + min);
        if (this.calCache != null && this.calCacheZone == unified) {
            return this.calCache;
        }
        StringBuffer zoneID = new StringBuffer("GMT");
        zoneID.append(sign < 0 ? (char)'-' : '+');
        if (hr < 10) {
            zoneID.append('0');
        }
        zoneID.append(hr);
        if (min < 10) {
            zoneID.append('0');
        }
        zoneID.append(min);
        TimeZone syntheticTZ = TimeZone.getTimeZone(zoneID.toString());
        this.calCache = new GregorianCalendar(syntheticTZ);
        this.calCacheZone = unified;
        return this.calCache;
    }

    private ParsedTimestamp loadCalendar(Calendar defaultTz, String str, String type) throws SQLException {
        char[] s = str.toCharArray();
        int slen = s.length;
        ParsedTimestamp result = new ParsedTimestamp();
        try {
            char sep;
            int start = TimestampUtils.skipWhitespace(s, 0);
            int end = TimestampUtils.firstNonDigit(s, start);
            if (TimestampUtils.charAt(s, end) == '-') {
                result.hasDate = true;
                result.year = TimestampUtils.number(s, start, end);
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                result.month = TimestampUtils.number(s, start, end);
                sep = TimestampUtils.charAt(s, end);
                if (sep != '-') {
                    throw new NumberFormatException("Expected date to be dash-separated, got '" + sep + "'");
                }
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                result.day = TimestampUtils.number(s, start, end);
                start = TimestampUtils.skipWhitespace(s, end);
            }
            if (Character.isDigit(TimestampUtils.charAt(s, start))) {
                result.hasTime = true;
                end = TimestampUtils.firstNonDigit(s, start);
                result.hour = TimestampUtils.number(s, start, end);
                sep = TimestampUtils.charAt(s, end);
                if (sep != ':') {
                    throw new NumberFormatException("Expected time to be colon-separated, got '" + sep + "'");
                }
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                result.minute = TimestampUtils.number(s, start, end);
                sep = TimestampUtils.charAt(s, end);
                if (sep != ':') {
                    throw new NumberFormatException("Expected time to be colon-separated, got '" + sep + "'");
                }
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                result.second = TimestampUtils.number(s, start, end);
                start = end;
                if (TimestampUtils.charAt(s, start) == '.') {
                    end = TimestampUtils.firstNonDigit(s, start + 1);
                    int num = TimestampUtils.number(s, start + 1, end);
                    for (int numlength = end - (start + 1); numlength < 9; ++numlength) {
                        num *= 10;
                    }
                    result.nanos = num;
                    start = end;
                }
                start = TimestampUtils.skipWhitespace(s, start);
            }
            if ((sep = TimestampUtils.charAt(s, start)) == '-' || sep == '+') {
                int tzmin;
                int tzsign = sep == '-' ? -1 : 1;
                end = TimestampUtils.firstNonDigit(s, start + 1);
                int tzhr = TimestampUtils.number(s, start + 1, end);
                start = end;
                sep = TimestampUtils.charAt(s, start);
                if (sep == ':') {
                    end = TimestampUtils.firstNonDigit(s, start + 1);
                    tzmin = TimestampUtils.number(s, start + 1, end);
                    start = end;
                } else {
                    tzmin = 0;
                }
                result.tz = this.getCalendar(tzsign, tzhr, tzmin);
                start = TimestampUtils.skipWhitespace(s, start);
            }
            if (result.hasDate && start < slen) {
                String eraString = new String(s, start, slen - start);
                if (eraString.startsWith("AD")) {
                    result.era = 1;
                    start += 2;
                } else if (eraString.startsWith("BC")) {
                    result.era = 0;
                    start += 2;
                }
            }
            if (start < slen) {
                throw new NumberFormatException("Trailing junk on timestamp: '" + new String(s, start, end - start) + "'");
            }
            if (!result.hasTime && !result.hasDate) {
                throw new NumberFormatException("Timestamp has neither date nor time");
            }
        }
        catch (NumberFormatException nfe) {
            throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{type, str}), PSQLState.BAD_DATETIME_FORMAT, (Throwable)nfe);
        }
        return result;
    }

    private static void showParse(String type, String what, Calendar cal, Date result, Calendar resultCal) {
    }

    private static void showString(String type, Calendar cal, Date value, String result) {
    }

    public synchronized Timestamp toTimestamp(Calendar cal, String s) throws SQLException {
        if (s == null) {
            return null;
        }
        int slen = s.length();
        if (slen == 8 && s.equals("infinity")) {
            return new Timestamp(9223372036825200000L);
        }
        if (slen == 9 && s.equals("-infinity")) {
            return new Timestamp(-9223372036832400000L);
        }
        if (cal == null) {
            cal = this.defaultCal;
        }
        ParsedTimestamp ts = this.loadCalendar(cal, s, "timestamp");
        Calendar useCal = ts.tz == null ? cal : ts.tz;
        useCal.set(0, ts.era);
        useCal.set(1, ts.year);
        useCal.set(2, ts.month - 1);
        useCal.set(5, ts.day);
        useCal.set(11, ts.hour);
        useCal.set(12, ts.minute);
        useCal.set(13, ts.second);
        useCal.set(14, 0);
        Timestamp result = new Timestamp(useCal.getTime().getTime());
        result.setNanos(ts.nanos);
        TimestampUtils.showParse("timestamp", s, cal, result, useCal);
        return result;
    }

    public synchronized Time toTime(Calendar cal, String s) throws SQLException {
        if (s == null) {
            return null;
        }
        int slen = s.length();
        if (slen == 8 && s.equals("infinity") || slen == 9 && s.equals("-infinity")) {
            throw new PSQLException(GT.tr("Infinite value found for timestamp/date. This cannot be represented as time."), PSQLState.DATETIME_OVERFLOW);
        }
        if (cal == null) {
            cal = this.defaultCal;
        }
        ParsedTimestamp ts = this.loadCalendar(cal, s, "time");
        Calendar useCal = ts.tz == null ? cal : ts.tz;
        useCal.set(11, ts.hour);
        useCal.set(12, ts.minute);
        useCal.set(13, ts.second);
        useCal.set(14, (ts.nanos + 500000) / 1000000);
        if (ts.hasDate) {
            useCal.set(0, ts.era);
            useCal.set(1, ts.year);
            useCal.set(2, ts.month - 1);
            useCal.set(5, ts.day);
            cal.setTime(new java.sql.Date(useCal.getTime().getTime()));
            useCal = cal;
        }
        useCal.set(0, 1);
        useCal.set(1, 1970);
        useCal.set(2, 0);
        useCal.set(5, 1);
        Time result = new Time(useCal.getTime().getTime());
        TimestampUtils.showParse("time", s, cal, result, useCal);
        return result;
    }

    public synchronized java.sql.Date toDate(Calendar cal, String s) throws SQLException {
        if (s == null) {
            return null;
        }
        int slen = s.length();
        if (slen == 8 && s.equals("infinity")) {
            return new java.sql.Date(9223372036825200000L);
        }
        if (slen == 9 && s.equals("-infinity")) {
            return new java.sql.Date(-9223372036832400000L);
        }
        if (cal == null) {
            cal = this.defaultCal;
        }
        ParsedTimestamp ts = this.loadCalendar(cal, s, "date");
        Calendar useCal = ts.tz == null ? cal : ts.tz;
        useCal.set(0, ts.era);
        useCal.set(1, ts.year);
        useCal.set(2, ts.month - 1);
        useCal.set(5, ts.day);
        if (ts.hasTime) {
            useCal.set(11, ts.hour);
            useCal.set(12, ts.minute);
            useCal.set(13, ts.second);
            useCal.set(14, (ts.nanos + 500000) / 1000000);
            cal.setTime(new java.sql.Date(useCal.getTime().getTime()));
            useCal = cal;
        }
        useCal.set(11, 0);
        useCal.set(12, 0);
        useCal.set(13, 0);
        useCal.set(14, 0);
        java.sql.Date result = new java.sql.Date(useCal.getTime().getTime());
        TimestampUtils.showParse("date", s, cal, result, useCal);
        return result;
    }

    public synchronized String toString(Calendar cal, Timestamp x) {
        if (cal == null) {
            cal = this.defaultCal;
        }
        cal.setTime(x);
        this.sbuf.setLength(0);
        if (x.getTime() == 9223372036825200000L) {
            this.sbuf.append("infinity");
        } else if (x.getTime() == -9223372036832400000L) {
            this.sbuf.append("-infinity");
        } else {
            TimestampUtils.appendDate(this.sbuf, cal);
            this.sbuf.append(' ');
            TimestampUtils.appendTime(this.sbuf, cal, x.getNanos());
            TimestampUtils.appendTimeZone(this.sbuf, cal);
            TimestampUtils.appendEra(this.sbuf, cal);
        }
        TimestampUtils.showString("timestamp", cal, x, this.sbuf.toString());
        return this.sbuf.toString();
    }

    public synchronized String toString(Calendar cal, java.sql.Date x) {
        if (cal == null) {
            cal = this.defaultCal;
        }
        cal.setTime(x);
        this.sbuf.setLength(0);
        if (x.getTime() == 9223372036825200000L) {
            this.sbuf.append("infinity");
        } else if (x.getTime() == -9223372036832400000L) {
            this.sbuf.append("-infinity");
        } else {
            TimestampUtils.appendDate(this.sbuf, cal);
            TimestampUtils.appendEra(this.sbuf, cal);
            TimestampUtils.appendTimeZone(this.sbuf, cal);
        }
        TimestampUtils.showString("date", cal, x, this.sbuf.toString());
        return this.sbuf.toString();
    }

    public synchronized String toString(Calendar cal, Time x) {
        if (cal == null) {
            cal = this.defaultCal;
        }
        cal.setTime(x);
        this.sbuf.setLength(0);
        TimestampUtils.appendTime(this.sbuf, cal, cal.get(14) * 1000000);
        if (this.min74) {
            TimestampUtils.appendTimeZone(this.sbuf, cal);
        }
        TimestampUtils.showString("time", cal, x, this.sbuf.toString());
        return this.sbuf.toString();
    }

    private static void appendDate(StringBuffer sb, Calendar cal) {
        int l_year = cal.get(1);
        int l_yearlen = String.valueOf(l_year).length();
        for (int i = 4; i > l_yearlen; --i) {
            sb.append("0");
        }
        sb.append(l_year);
        sb.append('-');
        int l_month = cal.get(2) + 1;
        if (l_month < 10) {
            sb.append('0');
        }
        sb.append(l_month);
        sb.append('-');
        int l_day = cal.get(5);
        if (l_day < 10) {
            sb.append('0');
        }
        sb.append(l_day);
    }

    private static void appendTime(StringBuffer sb, Calendar cal, int nanos) {
        int hours = cal.get(11);
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        int minutes = cal.get(12);
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        sb.append(':');
        int seconds = cal.get(13);
        if (seconds < 10) {
            sb.append('0');
        }
        sb.append(seconds);
        char[] decimalStr = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
        char[] nanoStr = Integer.toString(nanos).toCharArray();
        System.arraycopy(nanoStr, 0, decimalStr, decimalStr.length - nanoStr.length, nanoStr.length);
        sb.append('.');
        sb.append(decimalStr, 0, 6);
    }

    private static void appendTimeZone(StringBuffer sb, Calendar cal) {
        int offset = (cal.get(15) + cal.get(16)) / 1000 / 60;
        int absoff = Math.abs(offset);
        int hours = absoff / 60;
        int mins = absoff - hours * 60;
        sb.append(offset >= 0 ? " +" : " -");
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        if (mins < 10) {
            sb.append('0');
        }
        sb.append(mins);
    }

    private static void appendEra(StringBuffer sb, Calendar cal) {
        if (cal.get(0) == 0) {
            sb.append(" BC");
        }
    }

    private static int skipWhitespace(char[] s, int start) {
        int slen = s.length;
        for (int i = start; i < slen; ++i) {
            if (Character.isSpace(s[i])) continue;
            return i;
        }
        return slen;
    }

    private static int firstNonDigit(char[] s, int start) {
        int slen = s.length;
        for (int i = start; i < slen; ++i) {
            if (Character.isDigit(s[i])) continue;
            return i;
        }
        return slen;
    }

    private static int number(char[] s, int start, int end) {
        if (start >= end) {
            throw new NumberFormatException();
        }
        int n = 0;
        for (int i = start; i < end; ++i) {
            n = 10 * n + (s[i] - 48);
        }
        return n;
    }

    private static char charAt(char[] s, int pos) {
        if (pos >= 0 && pos < s.length) {
            return s[pos];
        }
        return '\u0000';
    }

    private static class ParsedTimestamp {
        boolean hasDate = false;
        int era = 1;
        int year = 1970;
        int month = 1;
        boolean hasTime = false;
        int day = 1;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nanos = 0;
        Calendar tz = null;

        private ParsedTimestamp() {
        }
    }
}

