/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.poller.snmp.job;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import com.clustercontrol.poller.snmp.SnmpPoller;
import com.clustercontrol.poller.snmp.SnmpPollerManager;

/**
 * SNMPポーリングを実行するジョブクラス（Quartzに登録します）
 * 
 * @version 3.0.0
 * @since 2.0.0
 */
public class SnmpPollingJob implements Job {
	private static Log m_log = LogFactory.getLog( SnmpPollingJob.class );

	/**
	 * Qurtzからコールバックされるメソッド
	 * ノード毎にスレッドを起動しポーリングを実行します。
	 */
	public void execute(JobExecutionContext context) throws JobExecutionException {
		// デバッグログ出力
		m_log.debug("execute start : ");
		
		// 引数を取得します
		JobDataMap dataMap = context.getJobDetail().getJobDataMap();

		// ポーラマネージャを参照するためのJNDI名
		String jndiName = dataMap.getString("jndiName");

		// ポーラグループ名
		String pollerGroup = dataMap.getString("pollerGroup");

		// ポーラ名
		String pollerName = dataMap.getString("pollerName");

		try {
			// 指定のポーラを取得する
			InitialContext ctx = new InitialContext();
			Object obj = ctx.lookup(jndiName);
			
			SnmpPollerManager manager = 
				(SnmpPollerManager)PortableRemoteObject.narrow(obj, SnmpPollerManager.class);

			SnmpPoller poller = manager.getPoller(pollerGroup, pollerName);

			// ポーリングを実行
			poller.run();
		} catch (NamingException e) {
			m_log.error(e.getMessage(), e);
		}
		
		// デバッグログ出力
		m_log.debug("execute end   : " + jndiName);
	}
}
