/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.priority.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.priority.bean.PriorityJudgmentInfo;
import com.clustercontrol.priority.factory.ModifyPriorityJudgment;
import com.clustercontrol.priority.factory.SelectPriorityJudgment;

/**
 * 重要度判定ルールを管理するSession Bean<BR>
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="PriorityController"	
 *           jndi-name="PriorityController"
 *           type="Stateless" 
 *           transaction-type="Container"
 *           
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class PriorityControllerBean implements javax.ejb.SessionBean {
    protected static Log m_log = LogFactory.getLog( PriorityControllerBean.class );
    
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * 重要度判定をマネージャから取得します。<BR>
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="PriorityJudgmentRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public PriorityJudgmentInfo getPriorityJudgment() throws FinderException, NamingException {

		SelectPriorityJudgment select = new SelectPriorityJudgment();
		PriorityJudgmentInfo info = select.getPriorityJudgment("DEFAULT");

		return info;
	}
	
	/**
	 * 重要度判定をマネージャに追加します。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PriorityJudgmentWrite"
     *     method-intf="Remote"
	 * 
	 * @param property
	 * @throws FinderException 
	 * @throws CreateException 
	 * @throws NamingException 
	 */
	public void addPriorityJudgment(PriorityJudgmentInfo info) throws NamingException, CreateException, FinderException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyPriorityJudgment modify = new ModifyPriorityJudgment();
		modify.addPriorityJudgment(info, pri.getName());
	}
	
	/**
	 * マネージャの重要度判定を変更します。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PriorityJudgmentWrite"
     *     method-intf="Remote"
	 * 
	 * @param property
	 * @throws FinderException 
	 * @throws NamingException 
	 */
	public void modifyPriorityJudgment(PriorityJudgmentInfo info) throws NamingException, FinderException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyPriorityJudgment modify = new ModifyPriorityJudgment();
		modify.modifyPriorityJudgment(info, pri.getName());
	}
	
	/**
	 * 重要度判定をマネージャから削除します。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PriorityJudgmentWrite"
     *     method-intf="Remote"
	 * 
	 * @param judgmentId
	 * @throws NamingException
	 * @throws RemoveException
	 * @throws FinderException
	 */
	public void deletePriorityJudgment(String judgmentId) throws NamingException, RemoveException, FinderException {
		ModifyPriorityJudgment modify = new ModifyPriorityJudgment();
		modify.deletePriorityJudgment(judgmentId);
	}
}
