/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Control;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.dialog.JobTreeDialog;

/**
 * ジョブ選択用のDialogCellEditorです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobDialogCellEditor extends DialogCellEditor {
	/** ツリーのみフラグ */
    private boolean m_treeOnly = false;
    /** 親ジョブID */
    private String m_parentJobId = null;
    /** ジョブID */
    private String m_jobId = null;

    /**
     * コンストラクタ 
     */
    public JobDialogCellEditor() {
        super();
        m_treeOnly = false;
    }

    /**
     * コンストラクタ
     * 
     * @param treeOnly true：ツリーのみ、false：ジョブ情報を含む
     */
    public JobDialogCellEditor(boolean treeOnly) {
        super();
        m_treeOnly = treeOnly;
    }

    /**
     * コンストラクタ
     * 
     * @param parentJobId 親ジョブID
     * @param jobId ジョブID
     */
    public JobDialogCellEditor(String parentJobId, String jobId) {
        super();
        m_treeOnly = true;
        m_parentJobId = parentJobId;
        m_jobId = jobId;
    }

    /**
     * ジョブ選択ダイアログを表示します。
     * 
     * @see org.eclipse.jface.viewers.DialogCellEditor#openDialogBox(org.eclipse.swt.widgets.Control)
     */
    protected Object openDialogBox(Control cellEditorWindow) {
        //ジョブツリーダイアログを表示する
        JobTreeDialog dialog = null;
        if (m_jobId == null) {
            dialog = new JobTreeDialog(cellEditorWindow.getShell(), m_treeOnly);
        } else {
            dialog = new JobTreeDialog(cellEditorWindow.getShell(),
                    m_parentJobId, m_jobId);
        }
        dialog.open();
        //選択したジョブツリーアイテムを取得する
        JobTreeItem item = null;
        if (dialog.getReturnCode() == JobTreeDialog.OK) {
            item = dialog.getSelectItem();
            if (item.getData().getType() == JobConstant.TYPE_COMPOSITE) {
                item = null;
            }
        }
        return item;
    }
}