/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;

/**
 * ジョブ[一覧]ビューのジョブ一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * ジョブツリーアイテムからジョブ一覧情報を作成する
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobList {
	
	/**
	 * 引数にて指定されたジョブツリーアイテムからジョブ一覧情報を作成する
	 * 
	 * @param item ジョブツリー情報
	 * @return ジョブ一覧情報（Objectの2次元配列）
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getJobList(JobTreeItem item) {
		ArrayList jobList = new ArrayList();
		
		if (item instanceof JobTreeItem) {
			JobTreeItem[] items = item.getChildren();
			
			for (int i = 0; i < items.length; i++) {
				ArrayList line = new ArrayList();
				line.add(items[i].getData().getId());
				line.add(items[i].getData().getName());
				line.add(new Integer(items[i].getData().getType()));
				
				JobCommandInfo exec = items[i].getData().getCommand();
				if (exec instanceof JobCommandInfo) {
					line.add(exec.getFacilityID());
					line.add(exec.getScope());
				} else {
					line.add(null);
					line.add(null);
				}
				JobWaitRuleInfo waitRule = items[i].getData().getWaitRule();
				if (waitRule instanceof JobWaitRuleInfo) {
					if (waitRule.getObject() != null
							&& waitRule.getObject().size() > 0) {
						line.add(new Integer(YesNoConstant.TYPE_YES));
					} else {
						line.add(new Integer(YesNoConstant.TYPE_NO));
					}
				} else {
					line.add(new Integer(YesNoConstant.TYPE_NO));
				}
				line.add(items[i].getData().getCreateUser());
				line.add(items[i].getData().getCreateTime());
				line.add(items[i].getData().getUpdateUser());
				line.add(items[i].getData().getUpdateTime());
				jobList.add(line);
			}
		} else {
			return null;
		}
		return jobList;
	}
}