/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.convert.TextElementConverter;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class StaticTextConverter
extends TextElementConverter {
    private static final StaticTextConverter INSTANCE = new StaticTextConverter();
    private final JRStyledTextParser styledTextParser = new JRStyledTextParser();

    private StaticTextConverter() {
    }

    public static StaticTextConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintText printText = new JRBasePrintText(reportConverter.getDefaultStyleProvider());
        JRStaticText staticText = (JRStaticText)element;
        this.copyTextElement(reportConverter, staticText, printText);
        printText.setText(staticText.getText());
        this.measureTextElement(printText);
        return printText;
    }

    protected JRStyledText getStyledText(JRPrintText printText) {
        String text = printText.getText();
        if (text == null) {
            text = "";
        }
        HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
        JRFontUtil.setAttributes(attributes, printText);
        attributes.put(TextAttribute.FOREGROUND, printText.getForecolor());
        JRStyledText styledText = null;
        if (printText.isStyledText()) {
            try {
                styledText = this.styledTextParser.parse(attributes, text);
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        if (styledText == null) {
            styledText = new JRStyledText();
            styledText.append(text);
            styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
        }
        return styledText;
    }
}

