/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.Deployer;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.scanner.DeploymentScanner;
import org.jboss.deployment.scanner.DeploymentScannerMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanProxyInstance;
import org.jboss.system.MissingAttributeException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.MuBoolean;
import org.jboss.util.MuLong;
import org.jboss.util.NullArgumentException;

public abstract class AbstractDeploymentScanner
extends ServiceMBeanSupport
implements DeploymentScanner,
DeploymentScannerMBean {
    protected MuLong scanPeriod = new MuLong(5000L);
    protected MuBoolean scanEnabled = new MuBoolean(true);
    protected Deployer deployer;
    protected MainDeployerMBean mainDeployer;
    protected ScannerThread scannerThread;
    private Thread shutdownHook;
    static /* synthetic */ Class class$org$jboss$deployment$scanner$AbstractDeploymentScanner$ScannerThread;

    public void setDeployer(ObjectName deployerName) {
        if (deployerName == null) {
            throw new NullArgumentException("deployerName");
        }
        this.deployer = (Deployer)MBeanProxyExt.create((Class)Deployer.class, (ObjectName)deployerName, (MBeanServer)this.server);
    }

    public ObjectName getDeployer() {
        return ((MBeanProxyInstance)this.deployer).getMBeanProxyObjectName();
    }

    public void setScanPeriod(long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("ScanPeriod must be >= 0; have: " + period);
        }
        this.scanPeriod.set(period);
    }

    public long getScanPeriod() {
        return this.scanPeriod.longValue();
    }

    public void setScanEnabled(boolean flag) {
        this.scanEnabled.set(flag);
    }

    public boolean isScanEnabled() {
        return this.scanEnabled.get();
    }

    public abstract void scan() throws Exception;

    protected void createService() throws Exception {
        if (this.deployer == null) {
            throw new MissingAttributeException("Deployer");
        }
        this.mainDeployer = (MainDeployerMBean)MBeanProxyExt.create((Class)MainDeployerMBean.class, (ObjectName)MainDeployerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.scannerThread = new ScannerThread(false);
        this.scannerThread.setDaemon(true);
        this.scannerThread.start();
        this.log.debug((Object)"Scanner thread started");
        final ScannerThread _scannerThread = this.scannerThread;
        this.shutdownHook = new Thread("DeploymentScanner Shutdown Hook"){
            ScannerThread scannerThread;
            {
                super(x0);
                this.scannerThread = _scannerThread;
            }

            public void run() {
                this.scannerThread.shutdown();
            }
        };
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to add shutdown hook", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        ScannerThread scannerThread = this.scannerThread;
        synchronized (scannerThread) {
            this.scannerThread.doScan();
            this.scannerThread.setEnabled(this.scanEnabled.get());
        }
    }

    protected void stopService() throws Exception {
        if (this.scannerThread != null) {
            this.scannerThread.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyService() throws Exception {
        this.deployer = null;
        if (this.scannerThread != null) {
            ScannerThread scannerThread = this.scannerThread;
            synchronized (scannerThread) {
                this.scannerThread.shutdown();
            }
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shutdownHook = null;
        this.scannerThread = null;
    }

    public class ScannerThread
    extends Thread {
        protected Logger log;
        protected boolean enabled;
        protected boolean shuttingDown;
        protected Object lock;

        public ScannerThread(boolean enabled) {
            super("ScannerThread");
            this.log = Logger.getLogger((Class)(class$org$jboss$deployment$scanner$AbstractDeploymentScanner$ScannerThread == null ? (class$org$jboss$deployment$scanner$AbstractDeploymentScanner$ScannerThread = AbstractDeploymentScanner.class$("org.jboss.deployment.scanner.AbstractDeploymentScanner$ScannerThread")) : class$org$jboss$deployment$scanner$AbstractDeploymentScanner$ScannerThread));
            this.lock = new Object();
            this.enabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Notified that enabled: " + enabled));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.enabled = false;
            this.shuttingDown = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Notified to shutdown");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.log.debug((Object)"Running");
            while (!this.shuttingDown) {
                if (!this.enabled) {
                    try {
                        this.log.debug((Object)"Disabled, waiting for notification");
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.loop();
            }
            this.log.debug((Object)"Shutdown");
        }

        public void doScan() {
            try {
                AbstractDeploymentScanner.this.scan();
            }
            catch (Exception e) {
                this.log.error((Object)"Scanning failed; continuing", (Throwable)e);
            }
        }

        protected void loop() {
            while (this.enabled) {
                this.doScan();
                try {
                    this.log.trace((Object)"Sleeping...");
                    Thread.sleep(AbstractDeploymentScanner.this.scanPeriod.longValue());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

