/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PerClassAdvice;
import org.jboss.aop.advice.PerInstanceAdvice;
import org.jboss.aop.advice.PerJoinpointAdvice;
import org.jboss.aop.advice.PerVmAdvice;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;

public class AdviceFactory
implements InterceptorFactory {
    private String advice;
    private AspectDefinition aspect;

    public AdviceFactory(AspectDefinition aspect, String adviceName) {
        this.aspect = aspect;
        this.advice = adviceName;
    }

    public AspectDefinition getAspect() {
        return this.aspect;
    }

    public String getAdvice() {
        return this.advice;
    }

    public boolean isDeployed() {
        return this.aspect.isDeployed();
    }

    public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
        if (this.aspect.getScope() == Scope.PER_VM) {
            try {
                return PerVmAdvice.generateOptimized(joinpoint, advisor.getManager(), this.advice, this.aspect);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.aspect.getScope() == Scope.PER_CLASS) {
            try {
                return PerClassAdvice.generate(joinpoint, advisor, this.advice, this.aspect);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.aspect.getScope() == Scope.PER_INSTANCE) {
            return new PerInstanceAdvice(this.advice, this.aspect, advisor);
        }
        if (this.aspect.getScope() == Scope.PER_JOINPOINT) {
            try {
                return PerJoinpointAdvice.createInterceptor(advisor, joinpoint, this.aspect, this.advice);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.aspect.getScope() == Scope.PER_CLASS_JOINPOINT) {
            Object instance = null;
            if (advisor instanceof GeneratedClassAdvisor) {
                instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(this.aspect, joinpoint);
                if (instance == null) {
                    ((GeneratedClassAdvisor)advisor).addPerClassJoinpointAspect(this.aspect, joinpoint);
                    instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(this.aspect, joinpoint);
                }
            } else if (joinpoint instanceof FieldJoinpoint) {
                FieldJoinpoint field = (FieldJoinpoint)joinpoint;
                ClassAdvisor classAdvisor = (ClassAdvisor)advisor;
                instance = classAdvisor.getFieldAspect(field, this.aspect);
            } else {
                instance = this.aspect.getFactory().createPerJoinpoint(advisor, joinpoint);
            }
            try {
                return PerVmAdvice.generateInterceptor(joinpoint, instance, this.advice);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String getName() {
        return this.aspect.getName() + "." + this.advice;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdviceFactory)) {
            return false;
        }
        AspectDefinition otherAspect = ((AdviceFactory)obj).getAspect();
        if (!this.aspect.getName().equals(otherAspect.getName())) {
            return false;
        }
        if (!this.aspect.getFactory().getName().equals(otherAspect.getFactory().getName())) {
            return false;
        }
        return this.advice.equals(((AdviceFactory)obj).advice);
    }
}

