/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.postgresforest.Driver;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;
import org.postgresforest.vm.ColumnInfo;
import org.postgresforest.vm.ForestSQLState;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.OrderInfo;
import org.postgresforest.vm.SelectColumnInfo;

public class Parser {
    public static final int NONE = -1;
    public static final int CALL = 1;
    public static final int CHECKPOINT = 2;
    public static final int COMMIT = 3;
    public static final int CONNECT = 4;
    public static final int CREATE = 5;
    public static final int DELETE = 6;
    public static final int DISCONNECT = 7;
    public static final int DROP = 8;
    public static final int GRANT = 9;
    public static final int INSERT = 10;
    public static final int REVOKE = 11;
    public static final int ROLLBACK = 12;
    public static final int SAVEPOINT = 13;
    public static final int SCRIPT = 14;
    public static final int SELECT = 15;
    public static final int SET = 16;
    public static final int SHUTDOWN = 17;
    public static final int UPDATE = 18;
    public static final int SEMICOLON = 19;
    public static final int ALTER = 20;
    public static final int ADD = 24;
    public static final int ALIAS = 35;
    public static final int AUTOCOMMIT = 43;
    public static final int CACHED = 31;
    public static final int COLUMN = 27;
    public static final int CONSTRAINT = 25;
    public static final int FOREIGN = 26;
    public static final int IGNORECASE = 41;
    public static final int INDEX = 22;
    public static final int LOGSIZE = 39;
    public static final int LOGTYPE = 40;
    public static final int MAXROWS = 42;
    public static final int MEMORY = 30;
    public static final int PASSWORD = 37;
    public static final int PRIMARY = 36;
    public static final int READONLY = 38;
    public static final int REFERENTIAL_INTEGRITY = 46;
    public static final int RENAME = 23;
    public static final int SOURCE = 44;
    public static final int FROM = 101;
    public static final int WHERE = 102;
    public static final int GROUP = 103;
    public static final int HAVING = 104;
    public static final int UNION = 105;
    public static final int INTERSECT = 106;
    public static final int EXCEPT = 107;
    public static final int ORDER = 108;
    public static final int LIMIT = 109;
    public static final int OFFSET = 110;
    public static final int FOR = 111;
    public static final int AS = 112;
    public static final int INNER = 113;
    public static final int OUTER = 114;
    public static final int RIGHT = 115;
    public static final int LEFT = 116;
    public static final int JOIN = 117;
    public static final int AND = 118;
    public static final int OR = 119;
    public static final int IN = 120;
    public static final int NOT = 121;
    public static final int ONLY = 122;
    public static final int INTO = 123;
    public static final int VALUES = 124;
    public static final int DEFAULT = 125;
    public static final int COUNT = 126;
    public static final int AGV = 127;
    public static final int MAX = 128;
    public static final int MIN = 129;
    public static final int STDDEV = 130;
    public static final int SUM = 131;
    public static final int VARIANCE = 132;
    public static final int ON = 133;
    public static final int LIKE = 134;
    public static final int CAST = 135;
    public static final int SUBSTRING = 136;
    public static final int TRIM = 137;
    public static final int EXTRACT = 138;
    public static final int SUBSTR = 139;
    public static final int OVERLAY = 140;
    public static final int DISTINCT = 141;
    public static final int ASC = 142;
    public static final int DESC = 143;
    public static final int USING = 144;
    public static final int BY = 145;
    public static final int NATURAL = 146;
    public static final int FULL = 147;
    public static final int IS = 148;
    protected static final CommandMap commandSet = new CommandMap();
    protected int m_type = -1;
    protected ArrayList m_tables;
    protected ArrayList m_updateCol;
    protected StreamTokenizer m_tokenizer;
    protected boolean m_orderBy = false;
    protected boolean m_groupBy = false;
    protected boolean m_Function = false;
    protected boolean m_JoinTable = false;
    protected boolean m_ForUpdate = false;
    protected boolean m_distinct = false;
    protected boolean m_union = false;
    protected boolean m_limit = false;
    protected int m_limitCount = 0;
    protected boolean m_offset = false;
    protected ArrayList m_orderList;
    protected ArrayList m_groupList;
    protected ArrayList m_selectList;
    protected boolean m_execFunction = false;
    protected boolean m_having = false;
    protected LogUtil m_logUtil;

    public Parser(LogUtil logUtil) {
        this.m_logUtil = logUtil;
    }

    protected void init() {
        if (this.m_tables == null) {
            this.m_tables = new ArrayList();
        } else {
            this.m_tables.clear();
        }
        if (this.m_updateCol == null) {
            this.m_updateCol = new ArrayList();
        } else {
            this.m_updateCol.clear();
        }
        if (this.m_orderList == null) {
            this.m_orderList = new ArrayList();
        } else {
            this.m_orderList.clear();
        }
        if (this.m_groupList == null) {
            this.m_groupList = new ArrayList();
        } else {
            this.m_groupList.clear();
        }
        if (this.m_selectList == null) {
            this.m_selectList = new ArrayList();
        } else {
            this.m_selectList.clear();
        }
    }

    public void parse(String sql) throws SQLException {
        this.init();
        this.initTokenizer(sql);
        try {
            this.checkToken(-3);
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.forest.paser.analysis", (PSQLState)ForestSQLState.INTERNAL_ERROR, (Object)e);
        }
        if (this.m_tokenizer.sval != null) {
            this.m_type = commandSet.getInt(this.m_tokenizer.sval);
        }
        try {
            switch (this.m_type) {
                case 15: {
                    this.parseSelect();
                    break;
                }
                case 10: {
                    int wtype;
                    if (this.checkToken(-3) && (wtype = commandSet.getInt(this.m_tokenizer.sval)) != 123) {
                        throw new PSQLException("postgresql.forest.paser.analysis", ForestSQLState.INTERNAL_ERROR);
                    }
                    this.parseInsert();
                    break;
                }
                case 6: {
                    this.parseDelete();
                    break;
                }
                case 18: {
                    this.parseUpdate();
                    break;
                }
            }
        }
        catch (IOException e1) {
            throw new PSQLException("postgresql.forest.paser.analysis", (PSQLState)ForestSQLState.INTERNAL_ERROR, (Object)e1);
        }
        if (Driver.logInfo) {
            switch (this.m_type) {
                case 15: {
                    this.m_logUtil.info("Parser Result: Command Type = SELECT");
                    break;
                }
                case 10: {
                    this.m_logUtil.info("Parser Result: Command Type = INSERT");
                    break;
                }
                case 6: {
                    this.m_logUtil.info("Parser Result: Command Type = DELETE");
                    break;
                }
                case 18: {
                    this.m_logUtil.info("Parser Result: Command Type = UPDATE");
                }
            }
            String tableName = "";
            for (int i = 0; i < this.m_tables.size(); ++i) {
                TableInfo tblInfo = (TableInfo)this.m_tables.get(i);
                tableName = tableName + tblInfo.getTableName() + ",";
            }
            this.m_logUtil.info("Parser Result: Extraction Table Name = " + tableName);
            String updateColumn = "";
            for (int i = 0; i < this.m_updateCol.size(); ++i) {
                UpdateColumnInfo colInf = (UpdateColumnInfo)this.m_updateCol.get(i);
                updateColumn = updateColumn + colInf.getName() + ",";
            }
            this.m_logUtil.info("Parser Result: Extraction Update Column Name = " + updateColumn);
            this.m_logUtil.info("Parser Result: ORDER BY = " + this.m_orderBy);
            this.m_logUtil.info("Parser Result: GROUP BY = " + this.m_groupBy);
            this.m_logUtil.info("Parser Result: FUNCTION = " + this.m_Function);
            this.m_logUtil.info("Parser Result: JOIN = " + this.m_JoinTable);
            this.m_logUtil.info("Parser Result: FOR UPDATE = " + this.m_ForUpdate);
            this.m_logUtil.info("Parser Result: DISTINCT = " + this.m_distinct);
            this.m_logUtil.info("Parser Result: UNION = " + this.m_union);
            this.m_logUtil.info("Parser Result: LIMIT = " + this.m_limit);
            this.m_logUtil.info("Parser Result: LIMIT COUNT = " + this.m_limitCount);
            this.m_logUtil.info("Parser Result: OFFSET = " + this.m_offset);
            String orderName = "";
            for (int i = 0; i < this.m_orderList.size(); ++i) {
                OrderInfo orderInfo = (OrderInfo)this.m_orderList.get(i);
                orderName = orderName + orderInfo.getName() + ",";
            }
            this.m_logUtil.info("Parser Result: ORDER LIST = " + orderName);
            String columnName = "";
            for (int i = 0; i < this.m_groupList.size(); ++i) {
                ColumnInfo columnInfo = (ColumnInfo)this.m_groupList.get(i);
                columnName = columnName + columnInfo.getName() + ",";
            }
            this.m_logUtil.info("Parser Result: GROUP LIST = " + columnName);
            String selectColumnName = "";
            for (int i = 0; i < this.m_selectList.size(); ++i) {
                SelectColumnInfo selectColumnInfo = (SelectColumnInfo)this.m_selectList.get(i);
                selectColumnName = selectColumnName + selectColumnInfo.getName() + ",";
            }
            this.m_logUtil.info("Parser Result: SELECT LIST = " + selectColumnName);
            this.m_logUtil.info("Parser Result: FUNCTION(TOTAL) = " + this.m_execFunction);
        }
    }

    protected void initTokenizer(String sql) {
        StringReader fr = new StringReader(sql);
        this.m_tokenizer = new StreamTokenizer(fr);
        this.m_tokenizer.resetSyntax();
        this.m_tokenizer.wordChars(97, 122);
        this.m_tokenizer.wordChars(65, 90);
        this.m_tokenizer.wordChars(95, 95);
        this.m_tokenizer.wordChars(46, 46);
        this.m_tokenizer.wordChars(48, 57);
        this.m_tokenizer.ordinaryChar(47);
        this.m_tokenizer.eolIsSignificant(true);
    }

    protected void parseSelect() throws IOException, SQLException {
        int token = -1;
        this.checkDistinct();
        if (!this.m_distinct) {
            this.m_tokenizer.pushBack();
        }
        int columnIndex = 1;
        SelectColumnInfo selectColumnInfo = new SelectColumnInfo(columnIndex);
        this.m_selectList.add(selectColumnInfo);
        block21: while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token == -3) {
                int wtype = commandSet.getInt(this.m_tokenizer.sval);
                String tmpSval = this.m_tokenizer.sval;
                block0 : switch (wtype) {
                    case 126: {
                        if (this.checkToken(40)) {
                            this.checkDistinct();
                            this.m_execFunction = true;
                            selectColumnInfo.setFunctionType(2);
                            this.forwardPparenthesis();
                            break;
                        }
                        selectColumnInfo.setName(tmpSval);
                        this.m_tokenizer.pushBack();
                        break;
                    }
                    case 128: {
                        if (this.checkToken(40)) {
                            this.m_execFunction = true;
                            selectColumnInfo.setFunctionType(0);
                            this.forwardPparenthesis();
                            break;
                        }
                        selectColumnInfo.setName(tmpSval);
                        this.m_tokenizer.pushBack();
                        break;
                    }
                    case 129: {
                        if (this.checkToken(40)) {
                            this.m_execFunction = true;
                            selectColumnInfo.setFunctionType(1);
                            this.forwardPparenthesis();
                            break;
                        }
                        selectColumnInfo.setName(tmpSval);
                        this.m_tokenizer.pushBack();
                        break;
                    }
                    case 131: {
                        if (this.checkToken(40)) {
                            this.checkDistinct();
                            this.m_execFunction = true;
                            selectColumnInfo.setFunctionType(3);
                            this.forwardPparenthesis();
                            break;
                        }
                        selectColumnInfo.setName(tmpSval);
                        this.m_tokenizer.pushBack();
                        break;
                    }
                    case 127: 
                    case 130: 
                    case 132: {
                        if (this.checkToken(40)) {
                            this.forwardPparenthesis();
                            this.m_Function = true;
                            break;
                        }
                        selectColumnInfo.setName(tmpSval);
                        this.m_tokenizer.pushBack();
                        break;
                    }
                    case 101: {
                        this.parseFrom();
                        break;
                    }
                    case 102: {
                        this.parseWhere();
                        break;
                    }
                    case 103: {
                        this.m_groupBy = true;
                        this.parseGroupBy();
                        break;
                    }
                    case 108: {
                        this.m_orderBy = true;
                        this.parseOrderBy();
                        break;
                    }
                    case 105: 
                    case 106: 
                    case 107: {
                        this.m_union = true;
                        return;
                    }
                    case 109: {
                        this.m_limit = true;
                        if (Driver.logDebug) {
                            this.m_logUtil.debug("LIMIT is specified");
                        }
                        if (this.checkToken(-3) && this.isNumeric(this.m_tokenizer.sval)) {
                            this.m_limitCount = new Integer(this.m_tokenizer.sval);
                            if (!Driver.logDebug) continue block21;
                            this.m_logUtil.debug("LIMIT Line:" + this.m_limitCount);
                            break;
                        }
                        throw new PSQLException("postgresql.forest.paser.analysis", ForestSQLState.INTERNAL_ERROR);
                    }
                    case 110: {
                        this.m_offset = true;
                        break;
                    }
                    case 104: {
                        this.m_having = true;
                        break;
                    }
                    case 123: {
                        throw new PSQLException("postgresql.forest.paser.selectinto", ForestSQLState.INTERNAL_ERROR);
                    }
                    case 111: {
                        if (!this.checkToken(-3) || (wtype = commandSet.getInt(this.m_tokenizer.sval)) != 18) continue block21;
                        this.m_ForUpdate = true;
                        if (!Driver.logDebug) continue block21;
                        this.m_logUtil.debug("FOR UPDATE is specified?");
                        break;
                    }
                    case 15: {
                        this.forwardPparenthesis();
                        break;
                    }
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: {
                        if (this.checkToken(40)) {
                            this.forwardPparenthesis();
                            break;
                        }
                        selectColumnInfo.setName(tmpSval);
                        this.m_tokenizer.pushBack();
                        break;
                    }
                    case 112: {
                        if (this.checkToken(-3)) {
                            selectColumnInfo.setAlias(this.m_tokenizer.sval);
                            break;
                        }
                        if (this.m_tokenizer.ttype == 34) {
                            StringBuffer value = new StringBuffer();
                            while ((token = this.m_tokenizer.nextToken()) != -1) {
                                if (token == -3) {
                                    value.append(this.m_tokenizer.sval);
                                    continue;
                                }
                                if (token == 34) {
                                    selectColumnInfo.setAlias(value.toString());
                                    break block0;
                                }
                                value.append((char)this.m_tokenizer.ttype);
                            }
                            continue block21;
                        }
                        throw new PSQLException("postgresql.forest.paser.analysis", ForestSQLState.INTERNAL_ERROR);
                    }
                    case 148: {
                        if (!this.checkToken(-3) || (wtype = commandSet.getInt(this.m_tokenizer.sval)) != 141) continue block21;
                        throw new PSQLException("postgresql.forest.paser.is.distinct.from", ForestSQLState.INTERNAL_ERROR);
                    }
                    default: {
                        if (this.checkToken(40)) {
                            this.forwardPparenthesis();
                            break;
                        }
                        selectColumnInfo.setName(tmpSval);
                        this.m_tokenizer.pushBack();
                    }
                }
                continue;
            }
            if (token == 44) {
                selectColumnInfo = new SelectColumnInfo(++columnIndex);
                this.m_selectList.add(selectColumnInfo);
                continue;
            }
            if (token == 42) {
                selectColumnInfo.setName("*");
                continue;
            }
            if (token != 40) continue;
            this.forwardPparenthesis();
        }
        for (int i = 0; i < this.m_selectList.size(); ++i) {
            selectColumnInfo = (SelectColumnInfo)this.m_selectList.get(i);
            if (selectColumnInfo.getName() == null || selectColumnInfo.getFunctionType() == -2) continue;
            this.m_Function = true;
            break;
        }
    }

    protected void checkDistinct() throws IOException {
        int wtype;
        if (this.checkToken(-3) && (wtype = commandSet.getInt(this.m_tokenizer.sval)) == 141) {
            this.m_distinct = true;
        }
    }

    protected void parseInsert() throws IOException, SQLException {
        int token = -1;
        boolean values = false;
        block5: while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token == -3) {
                int wtype = commandSet.getInt(this.m_tokenizer.sval);
                switch (wtype) {
                    case 123: {
                        continue block5;
                    }
                    case 124: {
                        values = true;
                        this.parseValues();
                        continue block5;
                    }
                    case 15: {
                        throw new PSQLException("postgresql.forest.paser.insertselect", ForestSQLState.INTERNAL_ERROR);
                    }
                }
                TableInfo tblInfo = new TableInfo();
                tblInfo.setTableName(this.m_tokenizer.sval);
                this.m_tables.add(tblInfo);
                continue;
            }
            if (token != 40) continue;
            this.parseColumns();
        }
        if (!values) {
            throw new PSQLException("postgresql.forest.paser.analysis", ForestSQLState.INTERNAL_ERROR);
        }
    }

    protected void parseUpdate() throws IOException, SQLException {
        int token = -1;
        block6: while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token != -3) continue;
            int wtype = commandSet.getInt(this.m_tokenizer.sval);
            switch (wtype) {
                case 101: {
                    this.parseFrom();
                    continue block6;
                }
                case 102: {
                    this.parseWhere();
                    continue block6;
                }
                case 122: {
                    continue block6;
                }
                case 16: {
                    this.parseSet();
                    continue block6;
                }
            }
            TableInfo tblInfo = new TableInfo();
            tblInfo.setTableName(this.m_tokenizer.sval);
            this.m_tables.add(tblInfo);
        }
    }

    protected void parseDelete() throws IOException, SQLException {
        int token = -1;
        while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token != -3) continue;
            int wtype = commandSet.getInt(this.m_tokenizer.sval);
            switch (wtype) {
                case 101: {
                    this.parseFrom();
                    break;
                }
                case 102: {
                    this.parseWhere();
                    break;
                }
            }
        }
    }

    public int getType() {
        return this.m_type;
    }

    public String[] getTables() {
        String[] tables = new String[this.m_tables.size()];
        for (int i = 0; i < tables.length; ++i) {
            TableInfo tblInfo = (TableInfo)this.m_tables.get(i);
            tables[i] = tblInfo.getTableName();
        }
        return tables;
    }

    public HashMap getWhereColumns(String table) {
        HashMap whereCol = null;
        try {
            TableInfo tblInf = this.getTableInfoByName(table);
            whereCol = tblInf.getWhereCol();
            if (whereCol == null) {
                whereCol = new HashMap();
            }
        }
        catch (Exception e) {
            whereCol = new HashMap();
        }
        return whereCol;
    }

    public ArrayList getSetColumns() {
        ArrayList<String> colNames = new ArrayList<String>();
        for (int i = 0; i < this.m_updateCol.size(); ++i) {
            UpdateColumnInfo colInf = (UpdateColumnInfo)this.m_updateCol.get(i);
            colNames.add(colInf.getName());
        }
        return colNames;
    }

    public ArrayList getInsertColumns() {
        ArrayList<String> colNames = new ArrayList<String>();
        for (int i = 0; i < this.m_updateCol.size(); ++i) {
            UpdateColumnInfo colInf = (UpdateColumnInfo)this.m_updateCol.get(i);
            String name = colInf.getName();
            if (name == null) continue;
            colNames.add(name);
        }
        if (colNames.size() == 0) {
            return null;
        }
        return colNames;
    }

    public String getInsertValue(String column) {
        for (int i = 0; i < this.m_updateCol.size(); ++i) {
            UpdateColumnInfo colInf = (UpdateColumnInfo)this.m_updateCol.get(i);
            if (column.compareToIgnoreCase(colInf.getName()) != 0) continue;
            return colInf.getValue();
        }
        return null;
    }

    public ArrayList getInsertValues() {
        ArrayList<String> colVals = new ArrayList<String>();
        for (int i = 0; i < this.m_updateCol.size(); ++i) {
            UpdateColumnInfo colInf = (UpdateColumnInfo)this.m_updateCol.get(i);
            colVals.add(colInf.getValue());
        }
        return colVals;
    }

    public boolean hasGroupBy() {
        return this.m_groupBy;
    }

    public boolean hasOrderBy() {
        return this.m_orderBy;
    }

    public boolean hasFunction() {
        return this.m_Function;
    }

    public boolean hasJoinTable() {
        return this.m_JoinTable;
    }

    public boolean hasDistinct() {
        return this.m_distinct;
    }

    public boolean hasUnion() {
        return this.m_union;
    }

    protected TableInfo getTableInfo(String table) {
        TableInfo tblInf = null;
        for (int i = 0; i < this.m_tables.size(); ++i) {
            tblInf = (TableInfo)this.m_tables.get(i);
            String tblName = tblInf.getTableName();
            String tblAlias = tblInf.getTableAlias();
            if (table.equals(tblName) || tblAlias != null && table.equals(tblAlias)) break;
        }
        return tblInf;
    }

    protected TableInfo getTableInfoByName(String table) {
        String tblName;
        TableInfo tblInf = null;
        for (int i = 0; i < this.m_tables.size() && !table.equals(tblName = (tblInf = (TableInfo)this.m_tables.get(i)).getTableName()); ++i) {
        }
        return tblInf;
    }

    protected void parseFrom() throws IOException, SQLException {
        int token = -1;
        block16: while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token != -3) continue;
            int wtype = commandSet.getInt(this.m_tokenizer.sval);
            block0 : switch (wtype) {
                case 104: {
                    this.m_having = true;
                }
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    this.m_tokenizer.pushBack();
                    return;
                }
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 146: 
                case 147: {
                    break;
                }
                case 117: {
                    this.m_JoinTable = true;
                    this.parseFrom();
                    break;
                }
                case 133: {
                    this.parseOn();
                    break;
                }
                case 144: {
                    if (this.checkToken(40)) {
                        this.forwardPparenthesis();
                        break;
                    }
                    throw new PSQLException("postgresql.forest.paser.analysis", ForestSQLState.INTERNAL_ERROR);
                }
                case 15: {
                    this.forwardPparenthesis();
                    while ((token = this.m_tokenizer.nextToken()) != -1) {
                        if (token != -3 || (wtype = commandSet.getInt(this.m_tokenizer.sval)) == 112) continue;
                        break block0;
                    }
                    continue block16;
                }
                case 122: {
                    throw new PSQLException("postgresql.forest.paser.inheritance", (Object)"ONLY");
                }
                default: {
                    TableInfo tblInfo = new TableInfo();
                    tblInfo.setTableName(this.m_tokenizer.sval);
                    if (this.checkToken(40)) {
                        this.forwardPparenthesis();
                        tblInfo.setTableName(null);
                    } else {
                        this.m_tokenizer.pushBack();
                    }
                    if (this.checkToken(42)) {
                        throw new PSQLException("postgresql.forest.paser.inheritance", (Object)(tblInfo.getTableName() + "*"));
                    }
                    this.m_tokenizer.pushBack();
                    block18: while ((token = this.m_tokenizer.nextToken()) != -1) {
                        if (token == -3) {
                            wtype = commandSet.getInt(this.m_tokenizer.sval);
                            switch (wtype) {
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: {
                                    break;
                                }
                                case 104: {
                                    this.m_having = true;
                                }
                                case 102: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 107: 
                                case 108: 
                                case 109: 
                                case 110: 
                                case 111: 
                                case 133: {
                                    this.m_tokenizer.pushBack();
                                    break block18;
                                }
                                case 117: {
                                    this.m_JoinTable = true;
                                    this.parseFrom();
                                    break block18;
                                }
                                default: {
                                    tblInfo.setTableAlias(this.m_tokenizer.sval);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (token == 40) {
                            this.forwardPparenthesis();
                            continue;
                        }
                        if (token != 44) continue;
                    }
                    if (tblInfo.getTableName() == null) break;
                    this.m_tables.add(tblInfo);
                }
            }
        }
    }

    protected ArrayList parseWhereIn() throws IOException, SQLException {
        int token = -1;
        ArrayList<String> values = new ArrayList<String>();
        StringBuffer value = new StringBuffer();
        boolean isQuoteChar = false;
        boolean isExit = false;
        while ((token = this.m_tokenizer.nextToken()) != -1) {
            switch (token) {
                case 41: {
                    if (isQuoteChar) {
                        value.append((char)this.m_tokenizer.ttype);
                    } else {
                        isExit = true;
                    }
                }
                case 44: {
                    if (isQuoteChar) {
                        value.append((char)this.m_tokenizer.ttype);
                        break;
                    }
                    values.add(value.toString());
                    value.delete(0, value.length());
                    break;
                }
                case 37: 
                case 42: 
                case 43: 
                case 45: 
                case 47: {
                    if (isQuoteChar) {
                        value.append((char)this.m_tokenizer.ttype);
                        break;
                    }
                    values.clear();
                    this.forwardPparenthesis();
                    isExit = true;
                    break;
                }
                case 39: {
                    if (isQuoteChar) {
                        int length = value.length();
                        if (length > 0 && value.substring(length - 1).equals("\\")) {
                            value.append((char)this.m_tokenizer.ttype);
                            break;
                        }
                        token = this.m_tokenizer.nextToken();
                        if (token == 39) {
                            value.append("\\'");
                            break;
                        }
                        this.m_tokenizer.pushBack();
                    }
                    isQuoteChar = !isQuoteChar;
                    break;
                }
                case -3: {
                    if (isQuoteChar) {
                        value.append(this.m_tokenizer.sval);
                        break;
                    }
                    if (this.isNumeric(this.m_tokenizer.sval)) {
                        value.append(this.m_tokenizer.sval);
                        break;
                    }
                    int wtype = commandSet.getInt(this.m_tokenizer.sval);
                    if (wtype != 15) break;
                    values.clear();
                    this.forwardPparenthesis();
                    isExit = true;
                    break;
                }
                default: {
                    if (!isQuoteChar) break;
                    value.append((char)this.m_tokenizer.ttype);
                }
            }
            if (!isExit) continue;
            break;
        }
        return values;
    }

    protected void parseWhere() throws IOException, SQLException {
        int token = -1;
        HashMap<String, ArrayList> colMap = new HashMap<String, ArrayList>();
        StringBuffer value = new StringBuffer();
        boolean isQuoteChar = false;
        boolean stop = false;
        String key = null;
        block16: while ((token = this.m_tokenizer.nextToken()) != -1) {
            switch (token) {
                case 37: 
                case 42: 
                case 43: 
                case 45: 
                case 47: {
                    if (isQuoteChar) {
                        value.append((char)this.m_tokenizer.ttype);
                        continue block16;
                    }
                    key = null;
                    continue block16;
                }
                case 61: {
                    continue block16;
                }
                case 33: 
                case 60: 
                case 62: {
                    key = null;
                    continue block16;
                }
                case 39: {
                    if (isQuoteChar) {
                        int length = value.length();
                        if (length > 0 && value.substring(length - 1).equals("\\")) {
                            value.append((char)this.m_tokenizer.ttype);
                            continue block16;
                        }
                        token = this.m_tokenizer.nextToken();
                        if (token == 39) {
                            value.append("\\'");
                            continue block16;
                        }
                        this.m_tokenizer.pushBack();
                    }
                    isQuoteChar = !isQuoteChar;
                    continue block16;
                }
                case -3: {
                    int wtype = commandSet.getInt(this.m_tokenizer.sval);
                    switch (wtype) {
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: {
                            break block16;
                        }
                        case 102: 
                        case 104: {
                            this.m_having = true;
                        }
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: {
                            this.m_tokenizer.pushBack();
                            break block16;
                        }
                        case 15: {
                            this.forwardPparenthesis();
                            continue block16;
                        }
                        case 118: {
                            ArrayList values;
                            if (key != null && value.length() != 0) {
                                values = null;
                                values = colMap.containsKey(key) ? (ArrayList)colMap.get(key) : new ArrayList();
                                values.add(value.toString());
                                colMap.put(key, values);
                            }
                            key = null;
                            value.delete(0, value.length());
                            continue block16;
                        }
                        case 119: 
                        case 121: 
                        case 134: 
                        case 135: {
                            stop = true;
                            continue block16;
                        }
                        case 120: {
                            ArrayList values = this.parseWhereIn();
                            if (!values.isEmpty()) {
                                colMap.put(key, values);
                            }
                            key = null;
                            value.delete(0, value.length());
                            continue block16;
                        }
                    }
                    if (isQuoteChar) {
                        value.append(this.m_tokenizer.sval);
                        continue block16;
                    }
                    if (this.isNumeric(this.m_tokenizer.sval)) {
                        value.append(this.m_tokenizer.sval);
                        continue block16;
                    }
                    key = this.m_tokenizer.sval.toLowerCase();
                    continue block16;
                }
                default: {
                    if (!isQuoteChar) continue block16;
                    value.append((char)this.m_tokenizer.ttype);
                    continue block16;
                }
            }
        }
        if (stop) {
            return;
        }
        if (key != null && value.length() != 0) {
            ArrayList values = null;
            values = colMap.containsKey(key) ? (ArrayList)colMap.get(key) : new ArrayList();
            values.add(value.toString());
            colMap.put(key, values);
        }
        Iterator iter = colMap.keySet().iterator();
        while (iter.hasNext()) {
            TableInfo tblInf;
            String strkey = (String)iter.next();
            Object colInfo = null;
            if (this.stringContains(strkey, '.')) {
                String[] keyspl = strkey.split("[.]");
                tblInf = this.getTableInfo(keyspl[0]);
                if (tblInf == null) continue;
                tblInf.addWhereCol(keyspl[1], (ArrayList)colMap.get(strkey));
                continue;
            }
            for (int i = 0; i < this.m_tables.size(); ++i) {
                tblInf = (TableInfo)this.m_tables.get(i);
                tblInf.addWhereCol(strkey, (ArrayList)colMap.get(strkey));
            }
        }
    }

    private boolean stringContains(String str, char ch) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            return true;
        }
        return false;
    }

    protected void forwardPparenthesis() throws IOException {
        int token;
        int nest = 1;
        while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token == 40) {
                ++nest;
                continue;
            }
            if (token != 41 || --nest != 0) continue;
            break;
        }
    }

    protected void parseOn() throws IOException {
        int token = -1;
        while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token != -3) continue;
            int wtype = commandSet.getInt(this.m_tokenizer.sval);
            switch (wtype) {
                case 113: 
                case 114: 
                case 115: 
                case 116: {
                    return;
                }
                case 104: {
                    this.m_having = true;
                }
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    this.m_tokenizer.pushBack();
                    return;
                }
            }
        }
    }

    protected void parseGroupBy() throws IOException {
        int token = -1;
        boolean execFlg = true;
        OrderInfo columnInfo = null;
        block5: while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token != -3) continue;
            if (this.isNumeric(this.m_tokenizer.sval)) {
                if (!execFlg) continue;
                int number = new Double(this.m_tokenizer.sval).intValue();
                columnInfo = new OrderInfo(number);
                this.m_groupList.add(columnInfo);
                continue;
            }
            int wtype = commandSet.getInt(this.m_tokenizer.sval);
            switch (wtype) {
                case 145: {
                    continue block5;
                }
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    this.m_tokenizer.pushBack();
                    return;
                }
                case 104: {
                    this.m_having = true;
                    this.m_tokenizer.pushBack();
                    return;
                }
            }
            if (!execFlg) continue;
            columnInfo = new OrderInfo(this.m_tokenizer.sval);
            this.m_groupList.add(columnInfo);
            for (int i = 0; i < this.m_selectList.size(); ++i) {
                SelectColumnInfo selectColumnInfo = (SelectColumnInfo)this.m_selectList.get(i);
                if (selectColumnInfo.getAlias() != null) {
                    if (this.m_tokenizer.sval.compareToIgnoreCase(selectColumnInfo.getAlias()) != 0) continue;
                    columnInfo.setNumber(selectColumnInfo.getNumber());
                    break;
                }
                if (selectColumnInfo.getName() == null || this.m_tokenizer.sval.compareToIgnoreCase(selectColumnInfo.getName()) != 0) continue;
                columnInfo.setNumber(selectColumnInfo.getNumber());
                break;
            }
            if (columnInfo.getNumber() != 0) continue;
            this.m_groupList.clear();
            execFlg = false;
        }
    }

    protected void parseOrderBy() throws IOException {
        int token = -1;
        boolean execFlg = true;
        OrderInfo orderInfo = null;
        block6: while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token != -3) continue;
            if (this.isNumeric(this.m_tokenizer.sval)) {
                if (!execFlg) continue;
                int number = new Double(this.m_tokenizer.sval).intValue();
                orderInfo = new OrderInfo(number);
                this.m_orderList.add(orderInfo);
                continue;
            }
            int wtype = commandSet.getInt(this.m_tokenizer.sval);
            switch (wtype) {
                case 145: {
                    continue block6;
                }
                case 109: 
                case 110: 
                case 111: {
                    this.m_tokenizer.pushBack();
                    return;
                }
                case 143: {
                    orderInfo.setSort(1);
                    continue block6;
                }
                case 144: {
                    this.m_orderList.clear();
                    execFlg = false;
                    continue block6;
                }
            }
            if (!execFlg) continue;
            orderInfo = new OrderInfo(this.m_tokenizer.sval);
            this.m_orderList.add(orderInfo);
            for (int i = 0; i < this.m_selectList.size(); ++i) {
                SelectColumnInfo selectColumnInfo = (SelectColumnInfo)this.m_selectList.get(i);
                if (selectColumnInfo.getAlias() != null) {
                    if (this.m_tokenizer.sval.compareToIgnoreCase(selectColumnInfo.getAlias()) != 0) continue;
                    orderInfo.setNumber(selectColumnInfo.getNumber());
                    break;
                }
                if (selectColumnInfo.getName() == null) continue;
                if (selectColumnInfo.getName().indexOf(42) != -1) break;
                if (this.m_tokenizer.sval.compareToIgnoreCase(selectColumnInfo.getName()) != 0) continue;
                orderInfo.setNumber(selectColumnInfo.getNumber());
                break;
            }
            if (orderInfo.getNumber() != 0) continue;
            this.m_orderList.clear();
            execFlg = false;
        }
    }

    protected void parseSet() throws IOException {
        int token = -1;
        StringBuffer value = new StringBuffer();
        String key = null;
        boolean isQuoteChar = false;
        block10: while ((token = this.m_tokenizer.nextToken()) != -1) {
            switch (token) {
                case 44: {
                    if (isQuoteChar) {
                        value.append((char)this.m_tokenizer.ttype);
                        continue block10;
                    }
                    if (key != null) {
                        this.m_updateCol.add(new UpdateColumnInfo(key, value));
                    }
                    key = null;
                    value.delete(0, value.length());
                    continue block10;
                }
                case 61: {
                    continue block10;
                }
                case 39: {
                    if (isQuoteChar) {
                        int length = value.length();
                        if (length > 0 && value.substring(length - 1).equals("\\")) {
                            value.append((char)this.m_tokenizer.ttype);
                            continue block10;
                        }
                        token = this.m_tokenizer.nextToken();
                        if (token == 39) {
                            value.append("\\'");
                            continue block10;
                        }
                        this.m_tokenizer.pushBack();
                    }
                    isQuoteChar = !isQuoteChar;
                    continue block10;
                }
                case -3: {
                    if (isQuoteChar) {
                        value.append(this.m_tokenizer.sval);
                        continue block10;
                    }
                    if (this.isNumeric(this.m_tokenizer.sval)) {
                        value.append(this.m_tokenizer.sval);
                        continue block10;
                    }
                    int wtype = commandSet.getInt(this.m_tokenizer.sval);
                    switch (wtype) {
                        case 101: 
                        case 102: {
                            if (key != null) {
                                this.m_updateCol.add(new UpdateColumnInfo(key, value));
                            }
                            this.m_tokenizer.pushBack();
                            return;
                        }
                        case 15: {
                            this.forwardPparenthesis();
                            value.delete(0, value.length());
                            continue block10;
                        }
                    }
                    key = this.m_tokenizer.sval;
                    continue block10;
                }
            }
            if (!isQuoteChar) continue;
            value.append((char)this.m_tokenizer.ttype);
        }
        if (key != null) {
            this.m_updateCol.add(new UpdateColumnInfo(key, value));
        }
    }

    protected void parseValues() throws IOException {
        UpdateColumnInfo upColInf;
        int token = -1;
        int colIdx = 0;
        StringBuffer value = new StringBuffer();
        boolean isQuoteChar = false;
        block8: while ((token = this.m_tokenizer.nextToken()) != -1) {
            switch (token) {
                case 44: {
                    UpdateColumnInfo upColInf2;
                    if (isQuoteChar) {
                        value.append((char)this.m_tokenizer.ttype);
                        continue block8;
                    }
                    if (this.m_updateCol.size() > colIdx) {
                        upColInf2 = (UpdateColumnInfo)this.m_updateCol.get(colIdx);
                        upColInf2.setValue(value.toString());
                    } else {
                        upColInf2 = new UpdateColumnInfo(null, value);
                        this.m_updateCol.add(upColInf2);
                    }
                    value.delete(0, value.length());
                    ++colIdx;
                    continue block8;
                }
                case 37: 
                case 42: 
                case 43: 
                case 45: 
                case 47: {
                    UpdateColumnInfo upColInf3;
                    if (isQuoteChar) {
                        value.append((char)this.m_tokenizer.ttype);
                        continue block8;
                    }
                    value.delete(0, value.length());
                    if (this.m_updateCol.size() > colIdx) {
                        upColInf3 = (UpdateColumnInfo)this.m_updateCol.get(colIdx);
                        upColInf3.setValue(null);
                    } else {
                        upColInf3 = new UpdateColumnInfo(null, value);
                        this.m_updateCol.add(upColInf3);
                    }
                    ++colIdx;
                    while ((token = this.m_tokenizer.nextToken()) != -1 && token != 44) {
                    }
                    continue block8;
                }
                case -3: {
                    if (isQuoteChar) {
                        value.append(this.m_tokenizer.sval);
                        continue block8;
                    }
                    if (this.isNumeric(this.m_tokenizer.sval)) {
                        value.append(this.m_tokenizer.sval);
                        continue block8;
                    }
                    int wtype = commandSet.getInt(this.m_tokenizer.sval);
                    if (wtype == 15) {
                        ++colIdx;
                        while ((token = this.m_tokenizer.nextToken()) != -1 && token != 44) {
                        }
                    }
                    value.delete(0, value.length());
                    if (this.m_updateCol.size() > colIdx) {
                        upColInf = (UpdateColumnInfo)this.m_updateCol.get(colIdx);
                        upColInf.setValue(null);
                        continue block8;
                    }
                    upColInf = new UpdateColumnInfo(null, value);
                    this.m_updateCol.add(upColInf);
                    continue block8;
                }
                case 39: {
                    if (isQuoteChar) {
                        int length = value.length();
                        if (length > 0 && value.substring(length - 1).equals("\\")) {
                            value.append((char)this.m_tokenizer.ttype);
                            continue block8;
                        }
                        token = this.m_tokenizer.nextToken();
                        if (token == 39) {
                            value.append("\\'");
                            continue block8;
                        }
                        this.m_tokenizer.pushBack();
                    }
                    isQuoteChar = !isQuoteChar;
                    continue block8;
                }
            }
            if (!isQuoteChar) continue;
            value.append((char)this.m_tokenizer.ttype);
        }
        if (value.length() != 0) {
            try {
                UpdateColumnInfo upColInf4 = (UpdateColumnInfo)this.m_updateCol.get(colIdx);
                upColInf4.setValue(value.toString());
            }
            catch (RuntimeException e) {
                upColInf = new UpdateColumnInfo(null, value);
                this.m_updateCol.add(upColInf);
            }
        }
    }

    protected void parseColumns() throws IOException, SQLException {
        int wtype;
        if (this.checkToken(-3) && (wtype = commandSet.getInt(this.m_tokenizer.sval)) == 15) {
            throw new PSQLException("postgresql.forest.paser.insertselect", ForestSQLState.INTERNAL_ERROR);
        }
        this.m_tokenizer.pushBack();
        int token = -1;
        StringBuffer value = new StringBuffer();
        while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token == -3) {
                if (value.length() != 0) continue;
                value.append(this.m_tokenizer.sval);
                continue;
            }
            if (token == 44) {
                this.m_updateCol.add(new UpdateColumnInfo(value.toString()));
                value.delete(0, value.length());
                continue;
            }
            if (token != 41) continue;
            this.m_updateCol.add(new UpdateColumnInfo(value.toString()));
            break;
        }
    }

    public boolean isForUpdate() {
        return this.m_ForUpdate;
    }

    public ArrayList getOrderList() {
        return this.m_orderList;
    }

    public ArrayList getGroupList() {
        return this.m_groupList;
    }

    public boolean hasLimit() {
        return this.m_limit;
    }

    public int getLimitCount() {
        return this.m_limitCount;
    }

    public boolean hasOffset() {
        return this.m_offset;
    }

    public ArrayList getSelectList() {
        return this.m_selectList;
    }

    public boolean hasExecFunction() {
        return this.m_execFunction;
    }

    protected boolean isNumeric(Object val) {
        String s = (String)val;
        if (s.charAt(0) != '0' && s.charAt(0) != '1' && s.charAt(0) != '2' && s.charAt(0) != '3' && s.charAt(0) != '4' && s.charAt(0) != '5' && s.charAt(0) != '6' && s.charAt(0) != '7' && s.charAt(0) != '8' && s.charAt(0) != '9' && s.charAt(0) != '.' && s.charAt(0) != '+' && s.charAt(0) != '-') {
            return false;
        }
        try {
            Double name = new Double(val.toString());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    protected boolean checkToken(int val) throws IOException {
        int token;
        while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token == 32 || token == 9 || token == 13 || token == 10) continue;
            if (token != val) break;
            return true;
        }
        return false;
    }

    public boolean hasHaving() {
        return this.m_having;
    }

    static {
        commandSet.put("alter", 20);
        commandSet.put("call", 1);
        commandSet.put("checkpoint", 2);
        commandSet.put("commit", 3);
        commandSet.put("connect", 4);
        commandSet.put("create", 5);
        commandSet.put("delete", 6);
        commandSet.put("disconnect", 7);
        commandSet.put("drop", 8);
        commandSet.put("grant", 9);
        commandSet.put("insert", 10);
        commandSet.put("revoke", 11);
        commandSet.put("rollback", 12);
        commandSet.put("savepoint", 13);
        commandSet.put("script", 14);
        commandSet.put("select", 15);
        commandSet.put("set", 16);
        commandSet.put("shutdown", 17);
        commandSet.put("update", 18);
        commandSet.put(";", 19);
        commandSet.put("index", 22);
        commandSet.put("rename", 23);
        commandSet.put("add", 24);
        commandSet.put("constraint", 25);
        commandSet.put("foreign", 26);
        commandSet.put("column", 27);
        commandSet.put("memory", 30);
        commandSet.put("cached", 31);
        commandSet.put("alias", 35);
        commandSet.put("primary", 36);
        commandSet.put("password", 37);
        commandSet.put("readonly", 38);
        commandSet.put("logsize", 39);
        commandSet.put("logtype", 40);
        commandSet.put("ignorecase", 41);
        commandSet.put("maxrows", 42);
        commandSet.put("autocommit", 43);
        commandSet.put("source", 44);
        commandSet.put("referential_integrity", 46);
        commandSet.put("from", 101);
        commandSet.put("where", 102);
        commandSet.put("group", 103);
        commandSet.put("having", 104);
        commandSet.put("union", 105);
        commandSet.put("intersect", 106);
        commandSet.put("except", 107);
        commandSet.put("order", 108);
        commandSet.put("limit", 109);
        commandSet.put("offset", 110);
        commandSet.put("for", 111);
        commandSet.put("as", 112);
        commandSet.put("inner", 113);
        commandSet.put("outer", 114);
        commandSet.put("right", 115);
        commandSet.put("left", 116);
        commandSet.put("join", 117);
        commandSet.put("and", 118);
        commandSet.put("or", 119);
        commandSet.put("in", 120);
        commandSet.put("not", 121);
        commandSet.put("only", 122);
        commandSet.put("into", 123);
        commandSet.put("values", 124);
        commandSet.put("default", 125);
        commandSet.put("count", 126);
        commandSet.put("avg", 127);
        commandSet.put("max", 128);
        commandSet.put("min", 129);
        commandSet.put("stddev", 130);
        commandSet.put("sum", 131);
        commandSet.put("variance", 132);
        commandSet.put("on", 133);
        commandSet.put("like", 134);
        commandSet.put("cast", 135);
        commandSet.put("substring", 136);
        commandSet.put("trim", 137);
        commandSet.put("extract", 138);
        commandSet.put("substr", 139);
        commandSet.put("overlay", 140);
        commandSet.put("distinct", 141);
        commandSet.put("asc", 142);
        commandSet.put("desc", 143);
        commandSet.put("using", 144);
        commandSet.put("by", 145);
        commandSet.put("natural", 146);
        commandSet.put("full", 147);
        commandSet.put("is", 148);
    }

    protected class UpdateColumnInfo {
        protected String m_name;
        protected String m_value;

        public UpdateColumnInfo(String name) {
            this.m_name = name;
            this.m_value = null;
        }

        public UpdateColumnInfo(String name, String value) {
            this.m_name = name;
            this.m_value = value;
        }

        public UpdateColumnInfo(String name, StringBuffer value) {
            this.m_name = name;
            this.m_value = value == null || value.length() == 0 ? null : value.toString();
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }

        public void setName(String string) {
            this.m_name = string;
        }

        public void setValue(String string) {
            this.m_value = string;
        }
    }

    protected class TableInfo {
        protected String m_tableName = null;
        protected String m_tableAlias = null;
        protected HashMap m_whereCol = null;

        protected TableInfo() {
        }

        public String getTableAlias() {
            return this.m_tableAlias;
        }

        public String getTableName() {
            return this.m_tableName;
        }

        public ArrayList getUpdateCol() {
            return Parser.this.m_updateCol;
        }

        public HashMap getWhereCol() {
            return this.m_whereCol;
        }

        public void setTableAlias(String string) {
            this.m_tableAlias = string.toLowerCase();
        }

        public void setTableName(String string) {
            this.m_tableName = string == null ? null : string.toLowerCase();
        }

        public void setUpdateCol(ArrayList list) {
            Parser.this.m_updateCol = list;
        }

        public void setWhereCol(HashMap map) {
            this.m_whereCol = map;
        }

        public void addWhereCol(String colName, ArrayList newVals) {
            if (this.m_whereCol == null) {
                this.m_whereCol = new HashMap();
            }
            if (this.m_whereCol.containsKey(colName)) {
                ArrayList vals = (ArrayList)this.m_whereCol.get(colName);
                vals.addAll(newVals);
            } else {
                this.m_whereCol.put(colName, newVals);
            }
        }
    }

    static class CommandMap
    extends HashMap {
        CommandMap() {
        }

        public int getInt(String key) {
            return this.getInt((Object)key.toLowerCase());
        }

        public int getInt(Object key) {
            Integer value = (Integer)this.get(key);
            return value == null ? -1 : value;
        }

        public int put(Object key, int value) {
            Integer oldvalue = this.put(key, new Integer(value));
            return oldvalue == null ? -1 : oldvalue;
        }
    }
}

