/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import javax.jms.JMSException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.logging.Logger;

public class ExceptionInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(ExceptionInterceptor.class);
    private boolean trace = log.isTraceEnabled();

    public String getName() {
        return "ExceptionInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        try {
            return invocation.invokeNext();
        }
        catch (JMSException e) {
            if (this.trace) {
                log.trace((Object)"Caught JMSException", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable t) {
            this.log(t);
            throw t;
        }
    }

    private void log(Throwable e) {
        log.error((Object)"Caught throwable", e);
        Throwable e2 = e.getCause();
        if (e2 != null) {
            this.log(e2);
        }
    }
}

