/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @version 3.1.0
 * @since 3.1.0
 *
 */
public class CreateSessionId {

	protected static Log m_log = LogFactory.getLog( CreateSessionId.class );
	
	private static String previousId = "";
	private static final String formatBase = "yyyyMMddHHmmss";
	private static final String formatAppend = "-000";
	
	public static synchronized String getNewSessionId(){
		
		String sessionId = null;
		String sessionIdPre = null;
		Date createTime = new Date();

		SimpleDateFormat dateFormat = new SimpleDateFormat(formatBase);
		sessionIdPre = dateFormat.format(createTime);
		
		DecimalFormat format = new DecimalFormat(formatAppend);
		
		for (int i = 0; i < 1000; i++){
			sessionId = sessionIdPre + format.format(i);
			if(!previousId.equals(sessionId)) {
				break;
			}
		}
		previousId = sessionId;
		m_log.debug("getNewSessionId() session id : " + sessionId);
		return sessionId;
	}
}
