/*
                                                                                                
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.poller.cfg;

import java.io.Serializable;
import java.net.InetAddress;

import com.clustercontrol.bean.PollerProtocolConstant;


/**
 * Wbemポーリングに必要な設定情報を保持するクラス
 * 
 * @version 3.1.0
 * @since 3.1.0
 */
public class WbemPollerConfig implements Serializable {
	private static final long serialVersionUID = 1819502052284113925L;
	
	private String pollingProtocol = PollerProtocolConstant.PROTOCOL_WBEM;
	private String userName = "root";
	private String password = "password";
	private String protocol = "http";
	private String nameSpace = "root/cimv2";
	private int port = 5988;
	private int retries = 1;
	private int timeout = 5000;

	
	/**
	 * ポーリングプロトコルを返します。
	 * @return ポーリングプロトコル
	 */
	public String getPollingProtocol() {
		return pollingProtocol;
	}

	/**
	 * ポーリングプロトコルを設定します。
	 * @param protocol ポーリングプロトコル
	 */
	public void setPollingProtocol(String pollingProtocol) {
		this.pollingProtocol = pollingProtocol;
	}
	
	/**
	 * 接続ユーザ名を返します。
	 * @return 接続ユーザ名
	 */
	public String getUserName() {
		return userName;
	}

	/**
	 * 接続ユーザ名を設定します。
	 * @param comunity 接続ユーザ名
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}

	/**
	 * 接続パスワードを返します。
	 * @return 接続パスワード
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * 接続パスワードを設定します。
	 * @param comunity 接続パスワード
	 */
	public void setPassword(String password) {
		this.password = password;
	}
	
	/**
	 * 通信プロトコルを返します。
	 * @return 通信プロトコル
	 */
	public synchronized String getProtocol() {
		return protocol;
	}

	/**
	 * 通信プロトコルを設定します。
	 * @param protocol 通信プロトコル
	 */
	public synchronized void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * ネームスペースを返します。
	 * @return ネームスペース
	 */
	public synchronized String getNameSpace() {
		return nameSpace;
	}

	/**
	 * ネームスペースを設定します。
	 * @param nameSpace ネームスペースプロトコル
	 */
	public synchronized void setNameSpace(String nameSpace) {
		this.nameSpace = nameSpace;
	}

	/**
	 * ポート番号を返します。
	 * @return ポート番号
	 */
	public int getPort() {
		return port;
	}

	/**
	 * ポート番号を設定します。
	 * @param port ポート番号
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * リトライ回数を返します。
	 * @return リトライ回数
	 */
	public int getRetries() {
		return retries;
	}

	/**
	 * リトライ回数を設定します。
	 * @param retries リトライ回数
	 */
	public void setRetries(int retries) {
		this.retries = retries;
	}

	/**
	 * タイムアウト時間を返します。
	 * @return タイムアウト時間
	 */
	public int getTimeout() {
		return timeout;
	}

	/**
	 * タイムアウト時間を設定します。
	 * @param timeout タイムアウト時間
	 */
	public void setTimeout(int timeout) {
		this.timeout = timeout;
	}

}
