/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.port.ejb.entity;

import javax.ejb.EntityBean;

/**
 * @ejb.bean name="MonitorPortInfo"
 *           jndi-name="MonitorPortInfo"
 *           type="CMP"
 *           schema="MonitorPortInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.container-configuration
 *     name="Instance Per Transaction CMP 2.x EntityBean"
 *  
 *  @jboss.optimistic-locking
 *     modified-strategy="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_monitor_port_info"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorPortInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="com.clustercontrol.port.ejb.entity.MonitorPortInfoPK"
 *   
 */
public abstract class MonitorPortInfoBean implements EntityBean {
	
	public MonitorPortInfoBean() {
		super();
	}
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public MonitorPortInfoPK ejbCreate(
			String monitorTypeId,
			String monitorId, 
			Integer portNo,
			Integer runCount, 
			Integer runInterval,
			Integer timeout,
			String serviceId
			) throws javax.ejb.CreateException {
		
		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setPortNo(portNo);
		this.setRunCount(runCount);
		this.setRunInterval(runInterval);
		this.setTimeout(timeout);
		this.setServiceId(serviceId);
		return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="port_number"
	 *     jdbc-type="INTEGER"
	 *     sql-type="INTEGER"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the portNo.
	 */
	public abstract Integer getPortNo();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The portNo to set.
	 */
	public abstract void setPortNo(Integer portNo);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="service_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the serviceId.
	 */
	public abstract String getServiceId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The serviceId to set.
	 */
	public abstract void setServiceId(String serviceId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="run_count"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the runCount.
	 */
	public abstract Integer getRunCount();

	/**
	 * @ejb.interface-method
	 * 
	 * @param runCount The runCount to set.
	 */
	public abstract void setRunCount(Integer runCount);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="run_interval"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the runInterval.
	 */
	public abstract Integer getRunInterval();

	/**
	 * @ejb.interface-method
	 * 
	 * @param runInterval The runInterval to set.
	 */
	public abstract void setRunInterval(Integer runInterval);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="timeout"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the timeout.
	 */
	public abstract Integer getTimeout();

	/**
	 * @ejb.interface-method
	 * 
	 * @param timeout The timeout to set.
	 */
	public abstract void setTimeout(Integer timeout);

}
