/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 収集するデバイスの種別を管理するEntity Bean <BR>
 * @ejb.bean name="DeviceTypeMst"
 *           jndi-name="DeviceTypeMst"
 *           type="CMP"
 *           schema="DeviceTypeMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="deviceType"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.read-only read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_device_type_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM DeviceTypeMst as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="java.lang.String"
 *   
 */
public abstract class DeviceTypeMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String deviceType,
			String deviceTypeName
			) throws javax.ejb.CreateException {
		
		this.setDeviceType(deviceType);
		this.setDeviceTypeName(deviceTypeName);
		
		return null;
	}
	
	/**
	 * コンストラクター
	 * @param deviceType デバイス種別
	 * @param deviceTypeName デバイス種別名称
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String deviceType,
			String deviceTypeName
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * デバイス種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the deviceType.
	 */
	public abstract String getDeviceType();

	/**
	 * デバイス種別を設定します。
	 * 
	 * @param deviceType The deviceType to set.
	 */
	public abstract void setDeviceType(String deviceType);

	/**
	 * デバイス種別名称を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_type_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the deviceTypeName.
	 */
	public abstract String getDeviceTypeName();

	/**
	 * デバイス種別名称を設定します。
	 * 
	 * @param deviceTypeName The deviceTypeName to set.
	 */
	public abstract void setDeviceTypeName(String deviceTypeName);

}
