/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.util.Iterator;
import java.util.List;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.bean.StatusInfoData;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoPK;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;


/**
 * ステータス情報を削除するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.0.0
 */
public class DeleteStatus {
	
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( DeleteStatus.class );
	
	/**
	 * 引数で指定されたステータス情報一覧を削除します。<BR>
	 * 
	 * 引数のlistは、StatusInfoDataが格納されたArrayListとして渡されます。<BR>
	 * 
	 * @param list 削除対象のステータス情報一覧（StatusInfoDataのList）
	 * @return 削除に成功した場合、</code> true </code>
	 * @throws NamingException
	 * @throws FinderException
	 * @throws RemoveException
	 * 
	 * @see com.clustercontrol.monitor.bean.StatusTabelDefine
	 * @see #delete(String, String, String)
	 */
	public boolean delete(List list) throws NamingException, FinderException, RemoveException {
		
		if (list != null && list.size()>0) {
			
//			ArrayList info = null;
//			for(int index=0; index<list.size(); index++){
//				
//				info = (ArrayList)list.get(index);
//				if (info != null && info.size()>0) {
//					this.delete((String) info.get(StatusTabelDefine.MONITOR_ID),
//							(String) info.get(StatusTabelDefine.PLUGIN_ID),
//							(String) info.get(StatusTabelDefine.FACILITY_ID)
//							);
//				}
//			}
			
			StatusInfoData status = null;
			Iterator itr = list.iterator();
			while (itr.hasNext()) {
				status = (StatusInfoData) itr.next();
				
				if (status != null) {
					this.delete(status.getMonitorId(), status.getPluginId(), status.getFacilityId());
				}
			}
			
		}
		return true;
	}
	
	/**
	 * 引数で指定されたステータス情報を削除します。<BR>
	 * 
	 * @param monitorId 削除対象の監視項目ID
	 * @param pluginId 削除対象のプラグインID
	 * @param facilityId 削除対象のファシリティID
	 * @throws NamingException
	 * @throws FinderException
	 * @throws RemoveException
	 * 
	 * @see com.clustercontrol.monitor.ejb.entity.StatusInfoBean#ejbFindByPrimaryKey(StatusInfoPK)
	 */
	public void delete(String monitorId,
			String pluginId,
			String facilityId
			) throws NamingException, FinderException, RemoveException {
		 
		try
		{
			// ステータス情報を取得
			StatusInfoPK pk = new StatusInfoPK(monitorId,
					pluginId,
					facilityId);
			StatusInfoLocal status = StatusInfoUtil.getLocalHome().findByPrimaryKey(pk);
			
			status.remove();
			
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId, monitorId, pluginId};
            apllog.put("SYS", "004", args);
			m_log.debug("modifyConfirm():" + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId, monitorId, pluginId};
            apllog.put("SYS", "004", args);
			m_log.debug("modifyConfirm():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId, monitorId, pluginId};
            apllog.put("SYS", "004", args);
			m_log.debug("modifyConfirm():" + e.getMessage());
			throw e;
		}
	}
}

