/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.EventTableDefine;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * イベント詳細情報表示用プロパティを取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、イベント詳細情報表示用プロパティを取得します。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetEventInfoProperty {

    // ----- instance メソッド ----- //

    /**
     * マネージャにSessionBean経由でアクセスし、引数で指定されたイベント情報のイベント詳細情報表示用プロパティを取得します。
     * <p>指定されたリスト（{@link ArrayList}）には、１イベント情報の各値が、
     * テーブルのカラム順（{@link com.clustercontrol.monitor.bean.EventTableDefine}）に格納されています。
	 * <p>
	 * <dl>
	 *  <dt>イベント情報</dt>
	 *  <dd>{ カラム1の値, カラム2の値, … }</dd>
	 * </dl>
     * 
     * @param list 取得対象のイベント情報
     * @return イベント詳細情報表示用プロパティ
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getEventInfoProperty(String, String, String, Date, Locale)
     */
    public Property getProperty(List list) {

        Property property = null;
        if (list != null) {
            String monitorId = (String) list.get(EventTableDefine.MONITOR_ID);
            String pluginId = (String) list.get(EventTableDefine.PLUGIN_ID);
            String facilityId = (String) list.get(EventTableDefine.FACILITY_ID);
            Date receiveTime = (Date) list.get(EventTableDefine.RECEIVE_TIME);

            MonitorController monitor = EjbConnectionManager.getConnectionManager().getMonitorController();

            try {
            	property = monitor.getEventInfoProperty(monitorId, pluginId, facilityId, receiveTime, Locale.getDefault());
            } catch (RemoteException e) {
    			if(e instanceof AccessException){
    				// アクセス権なしの場合、エラーダイアログを表示する
    	            MessageDialog.openInformation(null, Messages.getString("message"),
    	                    Messages.getString("message.accesscontrol.16"));
    			}
	        } catch (FinderException e) {
	        } catch (NamingException e) {
	        }
	    }
        return property;
   }
}