/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;

/**
 * スコープツリー用のラベルプロバイダクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityTreeLabelProvider extends LabelProvider {

    public String getText(Object element) {
        FacilityInfo info = ((FacilityTreeItem) element).getData();

        int type = info.getType();
        if (type == FacilityConstant.TYPE_COMPOSITE) {
            return info.getFacilityName();
        } else {
            return info.getFacilityName() + " (" + info.getFacilityId() + ")";
        }
    }

    public Image getImage(Object element) {
        ImageRegistry registry = ClusterControlPlugin.getDefault()
                .getImageRegistry();
        FacilityInfo facilityInfo = ((FacilityTreeItem)element).getData();
        switch (facilityInfo.getType()) {
        case FacilityConstant.TYPE_COMPOSITE:
            return registry.getDescriptor(ClusterControlPlugin.IMG_CONSOLE)
                    .createImage();
        case FacilityConstant.TYPE_SCOPE:
            return registry.getDescriptor(ClusterControlPlugin.IMG_SCOPE)
                    .createImage();
        case FacilityConstant.TYPE_NODE:
    		if (!facilityInfo.isValid()) {
    			return registry.getDescriptor(ClusterControlPlugin.IMG_NODE_INVALID)
    			.createImage();
        	} else {
        		return registry.getDescriptor(ClusterControlPlugin.IMG_NODE)
        		.createImage();
        	}
        default:
            return null;
        }
    }
}