/***************************************************************************
 *
 * Copyright (c) 1999 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: pkt_buffer.c,v 1.20 2005/11/23 08:49:21 bazsi Exp $
 *
 ***************************************************************************/
 
#include "pkt_buffer.h"
#include "list.h"
#include "io.h"
#include "format.h"

#include <string.h>

/* Appended by OSDC 2007/04/26 START */
#include "sjis_to_utf8.map"
#include "eucjp_to_utf8.map"
#include "../../src/cfgfile.h"
/* #include <iconv.h> */
/* Appended by OSDC 2007/04/26 END */

struct buffer_node {
	struct ol_queue_node header;
	struct ol_string *packet;
};

int pktbuf_dropped_pkts = 0;

/* CLASS:
     (class
       (name pkt_buffer)
       (super abstract_buffer)
       (vars
         (queue special-struct "struct ol_queue" #f do_free_buffer)
	 (pkt_flush simple int)
	 (queue_min simple int)
         (queue_size simple int)
         (queue_max simple int)))
*/

static void do_free_buffer(struct ol_queue *q);

#include "pkt_buffer.c.x"

static void do_free_buffer(struct ol_queue *q)
{
        FOR_QUEUE(q, struct buffer_node *, n) {
                ol_string_free(n->packet);
                ol_space_free(n);
        }
}

static int do_write(struct abstract_write *c, UINT32 length, UINT8 *data)
{
	return A_WRITE_STRING(c, c_format("%s", length, data));
}

static int do_write_str(struct abstract_write *c, struct ol_string *string)
{
	CAST(pkt_buffer, self, c);
	
	if (self->super.closed) {
		ol_string_free(string);
		return ST_FAIL | ST_CLOSE;
	}
	if (self->queue_size == self->queue_max) {
		/* fifo full */
		pktbuf_dropped_pkts++;
		ol_string_free(string);
		return ST_FAIL | ST_OK;
	}
	else {
		struct buffer_node *item;
		
		NEW_SPACE(item);
		item->packet = string;
		ol_queue_add_tail(&self->queue, &item->header);
		if (++self->queue_size == self->queue_max && self->super.writable)
			(*self->super.writable) = 0;
	}
	return ST_OK | ST_GOON;
}

static int do_flush_stream(struct abstract_buffer *c, struct abstract_write *w)
{
	CAST(pkt_buffer, self, c); 
	char buffer[4096];
	int res;
	int end;
	
	do {
		end = 0;
		{
			FOR_QUEUE(&self->queue, struct buffer_node *, item) {
				int avail = sizeof(buffer) - end;
				int move = LIBOL_MIN(item->packet->length, avail);
				
				if (avail <= 0 || move <= 0)
					break;
				memcpy(&buffer[end], item->packet->data, move);
				end += move;
			
				if (item->packet->length != move) {
					struct ol_string *s;
					
					s = item->packet;
					item->packet = c_format("%s", s->length - move, s->data + move);
					ol_string_free(s);
				} 
				else {
					
					/* successfully moved */
					self->queue_size--;
					ol_queue_remove((struct ol_queue_node *) item);
					ol_string_free(item->packet);
					ol_space_free(item);
				}
			}
		}
		
		if (end == 0)
			break;

/* Modified by OSDC 2007/04/24 START */

                /* res = A_WRITE(w, end, (UINT8 *) buffer); */

                {
                    char convertedStr[12288];
                    int convertedSize;
                    int writtenSize;

                    
                    convertedSize
                        = convertEncoding(buffer,
                                          end,
                                          convertedStr,
                                          configuration->input_encode );

                    /*
                     * because set variable res "before converted string size"
                     * or "-1", continue to write until completed ( or aborted ).
                     * if "really written size" equals buffer size,
                     * set variable res "before converted string size".
                     */
                    res = 0;
                    writtenSize = 0;
                    while (res >= 0) {
                        res = A_WRITE(w,
                                      convertedSize - writtenSize,
                                      (UINT8 *) (convertedStr + writtenSize) );
                        writtenSize += res;
                        if (writtenSize == convertedSize) {
                            res = end;
                            break;
                        }
                    }

                    /* free (convertedStr); */

                }

/* Modified by OSDC 2007/04/24 END */
		
		if (res >= 0) {
			if (end == res) {
				if (self->super.writable)
					(*self->super.writable) = 1;
			}
			else {
				/* this is slow, because of another memory move
				 * but this is run rarely anyway */
				struct buffer_node *item;
				
				NEW_SPACE(item);
				item->packet = c_format("%s", end - res, buffer + res);
				ol_queue_add_head(&self->queue, &item->header);
				if (++self->queue_size == self->queue_max && self->super.writable)
					(*self->super.writable) = 0;
				break;
			}
		}
		else {
			struct buffer_node *item;
			
			NEW_SPACE(item);
			item->packet = c_format("%s", end, buffer);
			ol_queue_add_head(&self->queue, &item->header);
			if (++self->queue_size == self->queue_max && self->super.writable)
				(*self->super.writable) = 0;
			
			werror("pkt_buffer::do_flush(): Error flushing data\n");
			return ST_DIE;
		}
	}
	while (1);
	return ST_OK | ST_GOON;
}

static int do_flush_pkt(struct abstract_buffer *c, struct abstract_write *w)
{
 	CAST(pkt_buffer, self, c);
	int res;

	FOR_QUEUE(&self->queue, struct buffer_node *, item) {

		res = A_WRITE(w, item->packet->length, item->packet->data);
		if (res >= 0) {
                        if (item->packet->length == res) {
                                self->queue_size--;
                                ol_queue_remove((struct ol_queue_node *) item);
                                ol_string_free(item->packet);
                                ol_space_free(item);
                                if (self->super.writable)
                                        (*self->super.writable) = 1;
			}
                        else if (res != 0) {
                                struct ol_string *s;
                                s = item->packet;
                                item->packet = c_format("%s", s->length - res, s->data + res);
                                ol_string_free(s);
                                break;
			}
                        else {
                              	break;
			}
		}
                else {
                      	verbose("pkt_buffer::do_flush(): Error flushing data\n");
			return ST_DIE;
		}
	}
        return ST_OK | ST_GOON;
}

static int do_flush(struct abstract_buffer *c, struct abstract_write *w)
{
	CAST(pkt_buffer, self, c);

	if (self->pkt_flush)
		return do_flush_pkt(c, w);
	else
		return do_flush_stream(c, w);
}


static int do_prepare_write(struct abstract_buffer *c)
{
	CAST(pkt_buffer, self, c);
	
	return self->queue_size > self->queue_min;
}

static void do_close(struct abstract_buffer *c)
{
	CAST(pkt_buffer, self, c);
	if (c->writable)
		*c->writable = 0;
	c->closed = 1;
	self->queue_min = 0;
}

struct abstract_buffer *make_pkt_buffer(int queue_max)
{
	NEW(pkt_buffer, self);
	
	self->super.super.write = do_write;
	self->super.super.writestr = do_write_str;
	self->super.flush = do_flush;
	self->super.prepare = do_prepare_write;
	self->super.close = do_close;
	
	ol_queue_init(&self->queue);
	self->queue_min = 0;
	self->queue_size = 0;
	self->queue_max = queue_max;
	
	return &self->super;
}

struct abstract_buffer *make_pkt_buffer_ext(int queue_min, int queue_max, int pkt_flush)
{
	struct abstract_buffer *b = make_pkt_buffer(queue_max);
	((struct pkt_buffer *) b)->queue_min = queue_min;
	((struct pkt_buffer *) b)->pkt_flush = pkt_flush;

	return b;
}

/* Appended by OSDC 2007/04/26 START */

/*
int convertEncoding(const char* inStr, int inSize, const char* outStr, int outSize)
{
    iconv_t iconvfd;
    int inByteLeft = inSize;
    int outByteLeft = outSize;

    iconvfd = iconv_open("SJIS", "UTF8");
    if (iconvfd < 0)
    {
        printf("ERROR!!!!!\n");
        return;
    }
    iconv(iconvfd, &inStr, &inByteLeft, &outStr, &outByteLeft);
    iconv_close(iconvfd);

    return outSize - outByteLeft;
}
*/

int getCharacterByte(unsigned int c)
{
    int ret = 0;
    do {
        ret++;
        c = c >> 8;
    } while ( c != 0 );
    return ret;
}

int addCharacter(char* outBuf, unsigned int c)
{
    int i;
    int size = getCharacterByte(c);
    for ( i = 0; i < size; i++)
        *(outBuf + i) = (c >> (8 * (size - i - 1))) & 0xFF;

    return size;
}

/*
unsigned int findConvertCode(unsigned int convertMap[][2],
                             int arrayLength,
                             unsigned int c,
                             unsigned int default_c)
{
    int i;

    for (i = 0; i < arrayLength; i++) {
        if (convertMap[i][0] == c) {
            return convertMap[i][1];
        }
    }
    return default_c;
}
*/

/* Appended by OSDC 2007/04/26 END */

/* Appended by OSDC 2007/10/02 START */

unsigned int findConvertCode(unsigned int convertMap[][2],
                             int arrayLength,
                             unsigned int c,
                             unsigned int default_c)
{
    int cmin = 0;
    int cmax = arrayLength - 1;
    int idx;
    unsigned int val;

    do
    {
        idx = (cmin + cmax) / 2;
        val = convertMap[idx][0];

        if (val < c) {
            cmin = idx + 1;
        }
        else if (c < val) {
            cmax = idx - 1;
        }
        else /* if (c == val) */ {
            return convertMap[idx][1];
        }

    } while (cmin <= cmax);

    return default_c;
}

/* Appended by OSDC 2007/10/02 END */


/* Appended by OSDC 2007/04/26 START */

int convertEncoding(char* inBuf, int inSize, char* outBuf, enum encode_type inputEncode)
{
    static const int eucjp_to_utf8_sbcs_length
        = sizeof(eucjp_to_utf8_sbcs) / sizeof(eucjp_to_utf8_sbcs[0]);
    static const int eucjp_to_utf8_sbcs_halfkana_length
        = sizeof(eucjp_to_utf8_sbcs_halfkana) / sizeof(eucjp_to_utf8_sbcs_halfkana[0]);
    static const int eucjp_to_utf8_dbcs_length
        = sizeof(eucjp_to_utf8_dbcs) / sizeof(eucjp_to_utf8_dbcs[0]);
    static const int eucjp_to_utf8_dbcs_sub_length
        = sizeof(eucjp_to_utf8_dbcs_sub) / sizeof(eucjp_to_utf8_dbcs_sub[0]);
    static const int sjis_to_utf8_sbcs_length
        = sizeof(sjis_to_utf8_sbcs) / sizeof(sjis_to_utf8_sbcs[0]);
    static const int sjis_to_utf8_dbcs_length
        = sizeof(sjis_to_utf8_dbcs) / sizeof(sjis_to_utf8_dbcs[0]);

    char* inIndex = inBuf;
    char* inIndexEnd = inBuf + inSize;
    char* outIndex = outBuf;
    int i;

    unsigned char c;
    int seekByte, readByte, writeByte;
    void* map;
    int mapLength;
    int convertCode;
    int undefCode[] = { 0x3F, 0x3F };

    if (inputEncode == UTF8) {
        memcpy(outBuf, inBuf, inSize);
        return inSize;
    }

    while (inIndex < inIndexEnd) {
        
        c = *inIndex < 0 ? *inIndex + 0x100 : *inIndex;

        switch (inputEncode) {
        case EUCJP:
            if ( ! (c == 0x8E || c == 0x8F || (0xA0 < c && c < 0xFF)) ) {
                /* euc jp ascii code */
                seekByte = 0;
                readByte = 1;
                map = eucjp_to_utf8_sbcs;
                mapLength = eucjp_to_utf8_sbcs_length;
            } else {
                switch (c) {
                case 0x8E: /* half kana code */
                    seekByte = 1;
                    readByte = 1;
                    map = eucjp_to_utf8_sbcs_halfkana;
                    mapLength = eucjp_to_utf8_sbcs_halfkana_length;
                    break;
                    
                case 0x8F: /* jis subset code */
                    seekByte = 1;
                    readByte = 2;
                    map = eucjp_to_utf8_dbcs_sub;
                    mapLength = eucjp_to_utf8_dbcs_sub_length;
                    break;
                    
                default: /* sjis normal code */
                    seekByte = 0;
                    readByte = 2;
                    map = eucjp_to_utf8_dbcs;
                    mapLength = eucjp_to_utf8_dbcs_length;
                    break;
                }
            }
            break;

        case SJIS:
            if ( c <= 0x80 || ( 0xA0 <= c && c <= 0xDF ) ) {
                /* sjis 1 byte code */
                seekByte = 0;
                readByte = 1;
                map = sjis_to_utf8_sbcs;
                mapLength = sjis_to_utf8_sbcs_length;
            } else {
                /* sjis 2 byte code */
                seekByte = 0;
                readByte = 2;
                map = sjis_to_utf8_dbcs;
                mapLength = sjis_to_utf8_dbcs_length;
            }
            break;
        }
                
        inIndex += seekByte;

        convertCode = 0;
        for (i = 0; i < readByte && inIndex < inIndexEnd; i++, inIndex++) {
            c = *inIndex < 0 ? *inIndex + 0x100 : *inIndex;
            convertCode = (convertCode << 8) + c; 
        }

        writeByte = addCharacter( outIndex,
                                  findConvertCode(map,
                                                  mapLength,
                                                  convertCode,
                                                  undefCode[readByte - 1] ));
        outIndex += writeByte;

    }
    return outIndex - outBuf;
}

/* Appended by OSDC 2007/04/26 END */
