package org.postgresforest.constant;

public enum ErrorStr {
    
    // メソッドのサポート
    NOT_IMPLEMENTED("このAPIはまだ実装していない"),
    NOT_SUPPORTED("このAPIはサポートしない（一部を除き現在JDBC1のAPIのみサポートしている）"),
    // 接続文字列に関する問題
    INVALID_FORESTURL("JDBCの接続文字列が jdbc:postgresforest://IP1:PORT1,IP2:PORT2/DB[?OPT1=VAL1[;OPT2=VAL2]...] の形になっていない"),
    INVALID_IPADDR("IPアドレスに無効な文字列が含まれている"),
    INVALID_PORT("PORT番号に無効な文字列が含まれている"),
    INVALID_DBNAME("DB名に無効な文字列が含まれている"),
    INVALID_OPTION("OPTIONの形式が無効"),
    SAME_ADDRESS("同じIP:PORTが指定されている"),
    
    // 管理情報ロード時のエラー
    MNGDB_CONNECT_FAILED("両系の管理情報データベースにコネクションを作成できなかった"),
    MNGDB_READ_FAILED("両系の管理情報データベースから情報を取得できなかった"),
    
    // 管理情報初回ロード時のエラー
    MNGINIT_CONNECT_FAILED("管理情報データベースへの初回アクセス時、両系共にコネクションを生成できなかった"),
    MNGINIT_LOAD_INFO_FAILED("管理情報データベースへの初回アクセス時、両系共に管理情報を取得できなかった"),
    MNGINIT_SYNTH_INFO_FAILED("両系の管理情報データベースから取得した情報を合成する際にserver_infoに差異がある"),
    MNGINIT_URL_DIFFERENT("指定した接続文字列と管理情報データベースから取得した接続先が異なる"),
    MNGINIT_INTERRUPT("管理情報の初期化最中にスレッドへのインタラプションが発生した"),
    
    // 管理情報生成時のエラー
    MNGDB_SERVERID_INVALID("管理情報データベース:server_info:serveridの値が異常"),
    MNGDB_UDBURL_INVALID("管理情報データベース:server_info:udb_urlが異常"),
    MNGDB_UDBVALIDITY_INVALID("管理情報データベース:server_info:udb_validityの値が異常"),
    MNGDB_GCONFIG_INVALID("管理情報データベース:global_configにデータが存在しない"),
    MNGDB_LOCALCONFIG_NOTFOUND("管理情報データベース:local_configに指定されたconfigidのコンフィグレーションが存在しない"),
    
    CONNECTION_CLOSED("既にこのコネクションは、closeが呼ばれたか、回復不能なエラーによって閉じられている"),
    RESOURCE_CLOSED("このJDBCオブジェクトは既に使用できない"),
    THREAD_INTERRUPTED("スレッドに割り込みが発生したため、操作に失敗した"),
    
    
    // プログラムの異常
    ILLEGAL_ARGUMENT("本来入るはずのない引数を指定されている（プログラムのミス）"),
    ILLEGAL_EXCEPTION("本来発生するはずがない例外を取得している（プログラムでのチェックミス）"),
    ILLEGAL_STATEMENT("本来到達するはずがない箇所に到達している（プログラムのロジックミス）"),
    
    MNGDB_SERVERINFO_ILLEGALRECORD("管理DBのServerInfoテーブルのレコード数が異常"),
    
    // その他のエラー
    STREAM_DUPLICATE_FAILED("InputStreamの複製のために読み込み最中にIOExceptionが発生した");
    
    private final String value;
    
    private ErrorStr(final String value) {
        this.value = value;
    }
    
    public String toString() {
        return value;
    }
}
