/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Section;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfTOCEntry;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfSection
extends RtfElement {
    protected RtfParagraph title = null;
    protected ArrayList items = new ArrayList();

    public RtfSection(RtfDocument doc, Section section) {
        super(doc);
        try {
            if (section.title() != null) {
                this.title = (RtfParagraph)doc.getMapper().mapElement(section.title());
            }
            if (this.document.getAutogenerateTOCEntries()) {
                StringBuffer titleText = new StringBuffer();
                Iterator it = section.title().iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    if (element.type() != 10) continue;
                    titleText.append(((Chunk)element).content());
                }
                if (titleText.toString().trim().length() > 0) {
                    RtfTOCEntry tocEntry = new RtfTOCEntry(titleText.toString(), section.title().font());
                    tocEntry.setRtfDocument(this.document);
                    this.items.add(tocEntry);
                }
            }
            Iterator iterator = section.iterator();
            while (iterator.hasNext()) {
                RtfBasicElement rtfElement = doc.getMapper().mapElement((Element)iterator.next());
                if (rtfElement == null) continue;
                this.items.add(rtfElement);
            }
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.title != null) {
                result.write(this.title.write());
                result.write(RtfParagraph.PARAGRAPH);
            }
            int i = 0;
            while (i < this.items.size()) {
                result.write(((RtfBasicElement)this.items.get(i)).write());
                ++i;
            }
            result.write(RtfParagraph.PARAGRAPH);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        int i = 0;
        while (i < this.items.size()) {
            ((RtfBasicElement)this.items.get(i)).setInTable(inTable);
            ++i;
        }
    }

    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        int i = 0;
        while (i < this.items.size()) {
            ((RtfBasicElement)this.items.get(i)).setInHeader(inHeader);
            ++i;
        }
    }
}

