/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.util.Vector;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpParseException;

public class Challenge {
    public String scheme;
    public HttpHeader params;

    private Challenge() {
    }

    public HttpHeader getParams() {
        return this.params;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getRealm() {
        return this.params.getField("realm");
    }

    public static Challenge[] parseChallenge(String line) throws HttpParseException {
        Vector<Challenge> challeges = new Vector<Challenge>();
        if (line == null || line.length() == 0) {
            throw new IllegalArgumentException("Invalid challenge");
        }
        Challenge challenge = new Challenge();
        challenge.params = new HttpHeader();
        char[] buf = line.toCharArray();
        try {
            int start = 0;
            int end = 0;
            do {
                String scheme;
                start = Challenge.skipSpaces(buf, start);
                end = Challenge.findEndOfToken(buf, start);
                challenge.scheme = scheme = line.substring(start, end);
                start = end;
                boolean skipComma = true;
                while ((skipComma || (start = Challenge.skipSpaces(buf, start)) < buf.length && buf[start] == ',') && (start = Challenge.skipSpaces(buf, start + 1)) < buf.length) {
                    end = Challenge.findEndOfToken(buf, start);
                    String paramname = line.substring(start, end);
                    start = end;
                    if (start >= buf.length || (start = Challenge.skipSpaces(buf, start)) >= buf.length) break;
                    if (buf[start] != '=') {
                        throw new HttpParseException("Invalid challenge");
                    }
                    if (start + 1 >= buf.length || (start = Challenge.skipSpaces(buf, start + 1)) >= buf.length) break;
                    end = Challenge.findEndOfToken(buf, start);
                    String value = line.substring(start, end);
                    start = end;
                    if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                        challenge.params.addField(paramname, value.substring(1, value.length() - 1));
                    } else {
                        challenge.params.addField(paramname, value);
                    }
                    skipComma = false;
                }
                challeges.add(challenge);
            } while (start < buf.length);
        }
        catch (HttpParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpParseException("Invalid challenge");
        }
        return challeges.toArray(new Challenge[challeges.size()]);
    }

    private static int skipSpaces(char[] buf, int pos) {
        while (pos < buf.length && Character.isSpaceChar(buf[pos])) {
            ++pos;
        }
        return pos;
    }

    private static int findEndOfToken(char[] buf, int pos) {
        if (buf[pos] == '\"') {
            while (buf[++pos] != '\"' && pos < buf.length) {
            }
            ++pos;
        } else {
            while (pos < buf.length && !Character.isSpaceChar(buf[pos]) && buf[pos] != ',' && buf[pos] != '=') {
                ++pos;
            }
        }
        return pos;
    }
}

