/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.LinkedList;
import org.jboss.security.SimplePrincipal;

public class NestableGroup
extends SimplePrincipal
implements Group {
    private LinkedList rolesStack = new LinkedList();

    public NestableGroup(String name) {
        super(name);
    }

    public Enumeration members() {
        return new IndexEnumeration();
    }

    public boolean removeMember(Principal user) {
        return this.rolesStack.remove(user);
    }

    public boolean addMember(Principal group) throws IllegalArgumentException {
        if (!(group instanceof Group)) {
            throw new IllegalArgumentException("The addMember argument must be a Group");
        }
        this.rolesStack.addFirst(group);
        return true;
    }

    public boolean isMember(Principal member) {
        if (this.rolesStack.size() == 0) {
            return false;
        }
        Group activeGroup = (Group)this.rolesStack.getFirst();
        boolean isMember = activeGroup.isMember(member);
        return isMember;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(this.getName());
        tmp.append("(members:");
        Enumeration iter = this.members();
        while (iter.hasMoreElements()) {
            tmp.append(iter.nextElement());
            tmp.append(',');
        }
        tmp.setCharAt(tmp.length() - 1, ')');
        return tmp.toString();
    }

    private class IndexEnumeration
    implements Enumeration {
        private Enumeration iter;

        IndexEnumeration() {
            if (NestableGroup.this.rolesStack.size() > 0) {
                Group grp = (Group)NestableGroup.this.rolesStack.get(0);
                this.iter = grp.members();
            }
        }

        public boolean hasMoreElements() {
            boolean hasMore = this.iter != null && this.iter.hasMoreElements();
            return hasMore;
        }

        public Object nextElement() {
            Object next = null;
            if (this.iter != null) {
                next = this.iter.nextElement();
            }
            return next;
        }
    }
}

