/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.MethodTagsHandler;
import xdoclet.util.LogUtil;
import xjavadoc.XClass;
import xjavadoc.XMethod;
import xjavadoc.XParameter;

public class PropertyTagsHandler
extends AbstractProgramElementTagsHandler {
    static /* synthetic */ Class class$xdoclet$tagshandler$PropertyTagsHandler;

    public static XMethod getXMethodForMethodName(String methodName) {
        return PropertyTagsHandler.getXMethodForMethodName(methodName, false);
    }

    public static XMethod getXMethodForMethodName(String methodName, boolean superclasses) {
        if (methodName != null) {
            return PropertyTagsHandler.extractXMethod(PropertyTagsHandler.getCurrentClass(), methodName, superclasses);
        }
        return null;
    }

    private static XMethod extractXMethod(XClass clazz, String methodName, boolean superclasses) {
        List methods = clazz.getMethods();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            XMethod method = (XMethod)i.next();
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        if (superclasses && clazz.getSuperclass() != null) {
            return PropertyTagsHandler.extractXMethod(clazz.getSuperclass(), methodName, superclasses);
        }
        return null;
    }

    public void forAllPropertiesWithTag(String template, Properties attributes) throws XDocletException {
        Log log = LogUtil.getLog(class$xdoclet$tagshandler$PropertyTagsHandler == null ? (class$xdoclet$tagshandler$PropertyTagsHandler = PropertyTagsHandler.class$("xdoclet.tagshandler.PropertyTagsHandler")) : class$xdoclet$tagshandler$PropertyTagsHandler, "forAllPropertiesWithTag");
        log.debug((Object)"in forAllPropertiesWithTag");
        String requiredTag = attributes.getProperty("tagName");
        if (requiredTag == null) {
            throw new XDocletException("missing required tag parameter in forAllPropertiesHavingTag");
        }
        XClass oldClass = PropertyTagsHandler.getCurrentClass();
        XClass superclass = null;
        ArrayList<String> already = new ArrayList<String>();
        do {
            XMethod oldCurrentMethod = PropertyTagsHandler.getCurrentMethod();
            List methods = PropertyTagsHandler.getCurrentClass().getMethods();
            Iterator j = methods.iterator();
            while (j.hasNext()) {
                XMethod currentMethod = (XMethod)j.next();
                log.debug((Object)("looking at method " + currentMethod.getName()));
                if (currentMethod.getDoc().hasTag(requiredTag)) {
                    PropertyTagsHandler.setCurrentMethod(currentMethod);
                    String propertyName = currentMethod.getPropertyName();
                    log.debug((Object)("property identified " + propertyName));
                    if (!already.contains(propertyName)) {
                        this.generate(template);
                        already.add(propertyName);
                    }
                }
                PropertyTagsHandler.setCurrentMethod(oldCurrentMethod);
            }
            superclass = PropertyTagsHandler.getCurrentClass().getSuperclass();
            if (superclass == null) continue;
            PropertyTagsHandler.pushCurrentClass(superclass);
        } while (superclass != null);
        PropertyTagsHandler.setCurrentClass(oldClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ifHasGetMethodWithTag(String template, Properties attributes) throws XDocletException {
        XMethod getMethod = this.getGetMethodWithTag(attributes);
        if (getMethod != null) {
            XMethod oldMethod = PropertyTagsHandler.getCurrentMethod();
            PropertyTagsHandler.setCurrentMethod(getMethod);
            try {
                this.generate(template);
            }
            finally {
                PropertyTagsHandler.setCurrentMethod(oldMethod);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ifHasSetMethodWithTag(String template, Properties attributes) throws XDocletException {
        XMethod setMethod = this.getSetMethodWithTag(attributes);
        if (setMethod != null) {
            XMethod oldMethod = PropertyTagsHandler.getCurrentMethod();
            PropertyTagsHandler.setCurrentMethod(setMethod);
            try {
                this.generate(template);
            }
            finally {
                PropertyTagsHandler.setCurrentMethod(oldMethod);
            }
        }
    }

    public String propertyTypeWithTag(Properties attributes) throws XDocletException {
        XMethod getter = this.getGetMethodWithTag(attributes);
        if (getter != null) {
            return MethodTagsHandler.getMethodTypeFor(getter);
        }
        XMethod setter = this.getSetMethodWithTag(attributes);
        if (setter != null) {
            XParameter parameter = (XParameter)setter.getParameters().iterator().next();
            return parameter.getType().getQualifiedName();
        }
        throw new XDocletException("no current property found for method " + PropertyTagsHandler.getCurrentMethod().getName());
    }

    public String paramValueWithTag(Properties attributes) throws XDocletException {
        XMethod setter;
        XMethod oldMethod = PropertyTagsHandler.getCurrentMethod();
        XMethod getter = this.getGetMethodWithTag(attributes);
        if (getter != null) {
            PropertyTagsHandler.setCurrentMethod(getter);
            String value = PropertyTagsHandler.delimit(PropertyTagsHandler.getTagValue(attributes, 1), attributes);
            if (value != null) {
                PropertyTagsHandler.setCurrentMethod(oldMethod);
                return value;
            }
        }
        if ((setter = this.getSetMethodWithTag(attributes)) != null) {
            PropertyTagsHandler.setCurrentMethod(setter);
            String value = PropertyTagsHandler.delimit(PropertyTagsHandler.getTagValue(attributes, 1), attributes);
            if (value != null) {
                PropertyTagsHandler.setCurrentMethod(oldMethod);
                return value;
            }
        }
        PropertyTagsHandler.setCurrentMethod(oldMethod);
        return attributes.getProperty("default");
    }

    public void ifHasParamWithTag(String template, Properties attributes) throws XDocletException {
        XMethod setter;
        XMethod oldMethod = PropertyTagsHandler.getCurrentMethod();
        XMethod getter = this.getGetMethodWithTag(attributes);
        if (getter != null) {
            PropertyTagsHandler.setCurrentMethod(getter);
            boolean value = PropertyTagsHandler.hasTag(attributes, 1);
            if (value) {
                PropertyTagsHandler.setCurrentMethod(oldMethod);
                this.generate(template);
                return;
            }
        }
        if ((setter = this.getSetMethodWithTag(attributes)) != null) {
            PropertyTagsHandler.setCurrentMethod(setter);
            boolean value = PropertyTagsHandler.hasTag(attributes, 1);
            if (value) {
                PropertyTagsHandler.setCurrentMethod(oldMethod);
                this.generate(template);
                return;
            }
        }
        PropertyTagsHandler.setCurrentMethod(oldMethod);
    }

    private XMethod getGetMethodWithTag(Properties attributes) throws XDocletException {
        String requiredTag = attributes.getProperty("tagName");
        if (requiredTag == null) {
            throw new XDocletException("missing required tag parameter in forAllPropertiesHavingTag");
        }
        XMethod currentMethod = PropertyTagsHandler.getCurrentMethod();
        if (currentMethod.getName().startsWith("get") || currentMethod.getName().startsWith("is")) {
            if (currentMethod.getDoc().hasTag(requiredTag)) {
                return currentMethod;
            }
            return null;
        }
        String attributeName = MethodTagsHandler.getMethodNameWithoutPrefixFor(currentMethod);
        XMethod getter = PropertyTagsHandler.getXMethodForMethodName("get" + attributeName);
        if (getter != null) {
            if (getter.getDoc().hasTag(requiredTag)) {
                return getter;
            }
            return null;
        }
        getter = PropertyTagsHandler.getXMethodForMethodName("is" + attributeName);
        if (getter != null && getter.getDoc().hasTag(requiredTag)) {
            return getter;
        }
        return null;
    }

    private XMethod getSetMethodWithTag(Properties attributes) throws XDocletException {
        String requiredTag = attributes.getProperty("tagName");
        if (requiredTag == null) {
            throw new XDocletException("missing required tag parameter in forAllPropertiesHavingTag");
        }
        XMethod currentMethod = PropertyTagsHandler.getCurrentMethod();
        if (currentMethod.getName().startsWith("set")) {
            if (currentMethod.getDoc().hasTag(requiredTag)) {
                return currentMethod;
            }
            return null;
        }
        String attributeName = MethodTagsHandler.getMethodNameWithoutPrefixFor(currentMethod);
        XMethod setter = PropertyTagsHandler.getXMethodForMethodName("set" + attributeName);
        if (setter != null && setter.getDoc().hasTag(requiredTag)) {
            return setter;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

