/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.examples;

import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.opennms.protocols.snmp.SnmpAgentHandler;
import org.opennms.protocols.snmp.SnmpAgentSession;
import org.opennms.protocols.snmp.SnmpEndOfMibView;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduBulk;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SimpleAgent
implements SnmpAgentHandler {
    private SnmpAgentSession m_session;
    private TreeMap m_mib = new TreeMap(new Comparator(){

        public int compare(Object o1, Object o2) {
            StringTokenizer stTokens1 = new StringTokenizer(o1.toString().trim(), ".");
            StringTokenizer stTokens2 = new StringTokenizer(o2.toString().trim(), ".");
            while (stTokens1.hasMoreTokens()) {
                int value1 = Integer.parseInt(stTokens1.nextToken());
                if (stTokens2.hasMoreTokens()) {
                    int value2 = Integer.parseInt(stTokens2.nextToken());
                    if (value1 == value2) continue;
                    return value1 - value2;
                }
                return 1;
            }
            if (stTokens2.hasMoreTokens()) {
                return 1;
            }
            return 0;
        }
    });
    private static SimpleAgent ms_agent;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$org$opennms$examples$SimpleAgent;

    SimpleAgent(String mibProperties) throws Exception {
        SnmpPeer peer = new SnmpPeer(InetAddress.getLocalHost(), 161);
        SnmpParameters params = peer.getParameters();
        params.setVersion(1);
        params.setReadCommunity("public");
        params.setWriteCommunity("public");
        this.m_session = new SnmpAgentSession((SnmpAgentHandler)this, peer);
        Properties pr = new Properties();
        InputStream input = (class$org$opennms$examples$SimpleAgent == null ? (class$org$opennms$examples$SimpleAgent = SimpleAgent.class$("org.opennms.examples.SimpleAgent")) : class$org$opennms$examples$SimpleAgent).getResourceAsStream(mibProperties);
        pr.load(input);
        input.close();
        Iterator<Object> i = pr.keySet().iterator();
        while (i.hasNext()) {
            String oid = ((String)i.next()).trim();
            String value = pr.getProperty(oid).trim();
            if (value.startsWith("?")) {
                final long factor = value.equals("?") ? 1000L : Long.parseLong(value.substring(1));
                this.m_mib.put(oid, new SnmpInt32(){
                    private int counter;
                    private long lastSec;
                    {
                        this.lastSec = System.currentTimeMillis() / factor;
                    }

                    public SnmpSyntax duplicate() {
                        SnmpInt32 dup = new SnmpInt32();
                        dup.setValue(this.getValue());
                        return dup;
                    }

                    public int getValue() {
                        this.counter = (int)((long)this.counter + (System.currentTimeMillis() / factor - this.lastSec));
                        this.lastSec = System.currentTimeMillis() / factor;
                        return this.counter;
                    }
                });
                continue;
            }
            if (value.startsWith("#")) {
                StringTokenizer stTokens = new StringTokenizer(value.substring(1), ", ");
                final ArrayList<Integer> list = new ArrayList<Integer>();
                while (stTokens.hasMoreTokens()) {
                    list.add(new Integer(stTokens.nextToken()));
                }
                this.m_mib.put(oid, new SnmpInt32(){
                    private int counter;

                    public SnmpSyntax duplicate() {
                        SnmpInt32 dup = new SnmpInt32();
                        dup.setValue(this.getValue());
                        return dup;
                    }

                    public int getValue() {
                        int value = (Integer)list.get(this.counter);
                        ++this.counter;
                        this.counter %= list.size();
                        return value;
                    }
                });
                continue;
            }
            this.m_mib.put(oid, new SnmpOctetString(value.getBytes()));
        }
    }

    public void SnmpAgentSessionError(SnmpAgentSession session, int error, Object ref) {
        new Exception().printStackTrace();
        System.exit(-1);
    }

    public void snmpReceivedPdu(SnmpAgentSession session, InetAddress manager, int port, SnmpOctetString community, SnmpPduPacket pdu) {
        if (pdu instanceof SnmpPduBulk) {
            SnmpPduRequest response = new SnmpPduRequest(162);
            response.setRequestId(pdu.getRequestId());
            this.doBulk(pdu.toVarBindArray(), pdu, response);
            try {
                session.send(new SnmpPeer(manager, port), (SnmpPduPacket)response);
            }
            catch (AsnEncodingException ex) {
                try {
                    response = new SnmpPduRequest(162);
                    response.setRequestId(pdu.getRequestId());
                    response.setErrorStatus(1);
                    response.setErrorIndex(0);
                    session.send(new SnmpPeer(manager, port), (SnmpPduPacket)response);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public SnmpPduRequest snmpReceivedGet(SnmpPduPacket pdu, boolean getNext) {
        SnmpVarBind[] binds = pdu.toVarBindArray();
        SnmpPduRequest response = new SnmpPduRequest(162);
        response.setRequestId(pdu.getRequestId());
        if (binds.length > 20) {
            response.setErrorStatus(1);
            response.setErrorIndex(0);
            return response;
        }
        if (pdu instanceof SnmpPduRequest) {
            int errorIndex = 0;
            if (getNext) {
                for (int i = 0; i < binds.length; ++i) {
                    String oid = binds[i].getName().toString();
                    SortedMap map = this.m_mib.tailMap(oid + ".0");
                    if (map.isEmpty()) {
                        response.addVarBind(new SnmpVarBind(oid));
                        errorIndex = i + 1;
                        break;
                    }
                    oid = map.firstKey();
                    response.addVarBind(new SnmpVarBind(oid, (SnmpSyntax)map.get(oid)));
                }
            } else {
                for (int i = 0; i < binds.length; ++i) {
                    String oid = binds[i].getName().toString();
                    SnmpSyntax value = (SnmpSyntax)this.m_mib.get(oid);
                    if (value == null) {
                        response.addVarBind(new SnmpVarBind(oid));
                        errorIndex = i + 1;
                        break;
                    }
                    response.addVarBind(new SnmpVarBind(oid, value));
                }
            }
            if (errorIndex > 0) {
                response.setErrorStatus(2);
                response.setErrorIndex(errorIndex);
            }
        } else if (pdu instanceof SnmpPduBulk) {
            this.doBulk(binds, pdu, response);
        } else {
            response.setErrorStatus(5);
            response.setErrorIndex(1);
        }
        return response;
    }

    private void doBulk(SnmpVarBind[] binds, SnmpPduPacket pdu, SnmpPduRequest response) {
        SortedMap map;
        String oid;
        int i;
        SnmpPduBulk bulk = (SnmpPduBulk)pdu;
        int nonRepeaters = bulk.getNonRepeaters();
        int maxRep = bulk.getMaxRepititions();
        for (i = 0; i < Math.min(nonRepeaters, binds.length); ++i) {
            oid = binds[i].getName().toString();
            map = this.m_mib.tailMap(oid + ".0");
            if (!map.isEmpty()) {
                oid = map.firstKey();
                response.addVarBind(new SnmpVarBind(oid, (SnmpSyntax)map.get(oid)));
                continue;
            }
            response.addVarBind(new SnmpVarBind(oid, (SnmpSyntax)new SnmpEndOfMibView()));
        }
        block1: for (i = nonRepeaters; i < binds.length; ++i) {
            oid = binds[i].getName().toString();
            map = this.m_mib.tailMap(oid + ".0");
            if (!map.isEmpty()) {
                Iterator<String> it = map.keySet().iterator();
                for (int j = 0; j < maxRep; ++j) {
                    if (!it.hasNext()) {
                        response.addVarBind(new SnmpVarBind(".1.9", (SnmpSyntax)new SnmpEndOfMibView()));
                        continue block1;
                    }
                    oid = it.next();
                    response.addVarBind(new SnmpVarBind(oid, (SnmpSyntax)map.get(oid)));
                }
                continue;
            }
            response.addVarBind(new SnmpVarBind(oid, (SnmpSyntax)new SnmpEndOfMibView()));
        }
    }

    private static List getOidList(SnmpVarBind[] binds) {
        ArrayList<SnmpObjectId> list = new ArrayList<SnmpObjectId>(binds.length);
        for (int i = 0; i < binds.length; ++i) {
            list.add(binds[i].getName());
        }
        return list;
    }

    public SnmpPduRequest snmpReceivedSet(SnmpPduPacket pdu) {
        SnmpVarBind[] binds = pdu.toVarBindArray();
        SnmpPduRequest response = new SnmpPduRequest(162);
        int errorIndex = 0;
        response.setRequestId(pdu.getRequestId());
        if (binds.length > 20) {
            response.setErrorStatus(1);
            response.setErrorIndex(0);
            return response;
        }
        for (int i = 0; i < binds.length; ++i) {
            String oid = binds[i].getName().toString();
            SnmpSyntax newValue = binds[i].getValue();
            SnmpSyntax value = (SnmpSyntax)this.m_mib.get(oid);
            if (value == null) {
                response.addVarBind(new SnmpVarBind(oid));
                errorIndex = i + 1;
                break;
            }
            this.m_mib.put(oid, newValue);
            response.addVarBind(new SnmpVarBind(oid, newValue));
        }
        if (errorIndex > 0) {
            response.setErrorStatus(2);
            response.setErrorIndex(errorIndex);
        }
        return response;
    }

    public static void startAgent(String mibProperties) throws Exception {
        SimpleAgent.stopAgent();
        System.out.println("Starting SNMP Agent on " + InetAddress.getLocalHost() + ":161 ....");
        ms_agent = new SimpleAgent(mibProperties);
    }

    public static void stopAgent() {
        if (ms_agent != null) {
            SimpleAgent.ms_agent.m_session.close();
            ms_agent = null;
        }
    }

    public static void main(String[] st) throws Exception {
        SimpleAgent.startAgent(st.length == 0 ? "agent-mib.properties" : st[0]);
        Thread.currentThread().join();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

