/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

*/

package com.clustercontrol.performance.bean;

import java.io.Serializable;

import com.clustercontrol.performance.bean.CollectorLockKey;

/**
 * 収集データの削除ロックの管理用の鍵として用いるクラス
 */
public class CollectorLockKey implements Serializable {
	private String ipAddress;
	private String user;
    
	/**
	 * 収集データの削除ロックの管理用の鍵クラスのインスタンスを返します。
	 * @param ipAddress 接続元クライアントのIPアドレス
	 * @param user 接続ユーザ名
	 */
    public CollectorLockKey(String ipAddress, String user){
    	this.ipAddress = ipAddress;
    	this.user = user;
    }
    
    /**
     * このオブジェクトと他のオブジェクトが等しいかどうかを示します。
     */
    public boolean equals(Object o) {  	
    	if(this == o){
    		return true;
    	}
    	
    	if(o instanceof CollectorLockKey){
    		CollectorLockKey other = (CollectorLockKey)o;
    		boolean equals = false;
    		
    		if(this.ipAddress == null || other.ipAddress == null || 
    				this.user == null || other.user == null){
    			equals = false;
    		} else  if(ipAddress.equals(other.ipAddress) && user.equals(other.user)){
    			equals = true;
    		}
    		
    		return equals;
    	} else {
    		return false;
    	}
    }
    
    /**
     * オブジェクトのハッシュコード値を返します。
     */
    public int hashCode() {
       int result = 17;

       result = 37*result + ((this.ipAddress != null) ? this.ipAddress.hashCode() : 0);
       result = 37*result + ((this.user != null) ? this.user.hashCode() : 0);

       return result;
    }
    
    /**
     * オブジェクトの文字列表現を返します。
     */
    public String toString(){
        String str = "{ipAddress=" + this.ipAddress + " " + "user=" + this.user + "}";

        return(str.toString());
    }
}
