/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.collectiverun.ejb.session.CollectiveRunController;
import com.clustercontrol.collectiverun.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 一括制御[履歴]テーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetHistoryTabelDefine {

    /**
     * 履歴テーブル定義を取得します。<BR>
     * 
     * @return 履歴テーブル定義
     */
    public static ArrayList get() {
        CollectiveRunController collectiveRun = EjbConnectionManager
                .getConnectionManager().getCollectiveRunController();

        ArrayList tableDefine = null;
        try {
            tableDefine = collectiveRun.getHistoryTableDefine(Locale
                    .getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        return tableDefine;
    }
}