/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.util.Messages;


/**
 * アプリケーション付き通知ID一覧コンポジットクラス<BR>
 * <p>
 * <dl>
 *  <dt>コンポジット</dt>
 *  <dd>「通知ID」 ラベル（親）</dd>
 *  <dd>「通知ID一覧」 フィールド（親）</dd>
 *  <dd>「選択」 ボタン（親）</dd>
 *  <dd>「アプリケーション」 テキストボックス</dd>
 * </dl>
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class NotifyInfoComposite extends NotifyIdListComposite {

    /** アプリケーション ラベル。 */
    private Label labelApplication = null;
    
    /** アプリケーション ラベル文字列。 */
    private Text textApplication = null;
    
    /** 入力値チェック用 */
    private ValidateResult validateResult = null;

    
	/**
     * インスタンスを返します。
	 * <p>
	 * 初期処理を呼び出し、コンポジットを配置します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * 
     * @see org.eclipse.swt.SWT
	 * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
	 * @see #initialize(Composite)
     */
    public NotifyInfoComposite(Composite parent, int style) {
    	super(parent, style, true);

        this.initialize(parent);
    }
    
    /**
     * インスタンスを返します。
     * <p>
	 * 初期処理を呼び出し、コンポジットを配置します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * @param text アプリケーション ラベル文字列
     * 
     * @see org.eclipse.swt.SWT
	 * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
	 * @see #initialize(Composite)
     */
    public NotifyInfoComposite(Composite parent, int style, String text) {
    	super(parent, style, text);

        this.initialize(parent);
    }

    /**
	 * コンポジットを配置します。
	 */
    private void initialize(Composite parent) {
    	
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 15;
        this.setLayout(layout);
        
        /*
         * アプリケーションID
         */
        // ラベル
        this.labelApplication = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.labelApplication.setLayoutData(gridData);
        this.labelApplication.setText(Messages.getString("application") + " : ");
        // テキスト
        this.textApplication = new Text(this, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textApplication.addVerifyListener(new StringVerifyListener(DataRangeConstant.VARCHAR_64));
        this.textApplication.setLayoutData(gridData);
    }

	
	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		this.textApplication.setEnabled(enabled);
	}
	
	/**
	 * アプリケーションを返します。
	 * 
	 * @return アプリケーション
	 */
	public String getApplication() {
		
		return this.textApplication.getText();
	}

	/**
	 * アプリケーションを設定します。
	 */
	public void setApplication(String string) {
		this.textApplication.setText(string);
	}
	
	/**
	 * 引数で指定された監視情報に、入力値を設定します。
	 * <p>
	 * 入力値チェックを行い、不正な場合は認証結果を返します。
	 * 不正ではない場合は、<code>null</code>を返します。
	 * 
	 * @param info	監視情報
	 * @return	検証結果
	 */
	public ValidateResult createInputData(MonitorInfo info){
		
		this.validateResult = null;
		if(info != null){
			boolean isSetNotifyId;
			
			//通知情報へのNotifyGroupIdのセット
			if(this.setNotifyGroupId(info.getNotifyGroupId())){
				//コンポジットから通知情報を取得します。
				info.setNotifyId(this.getNotify());
				isSetNotifyId = true;
			}
			else{
				// 警告出力用設定を返す
				setValidateResult(null,Messages.getString("message.notify.27"));
				isSetNotifyId = false;
			}
			
			// アプリケーションの設定
			if(this.getApplication() != null && !this.getApplication().equals("")){
				info.setApplication(this.getApplication());
			}
			else {
				if (isSetNotifyId) {
					setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.10"));
				}
			}
			
		}
		return this.validateResult;
	}
	
	/**
	 * 無効な入力値の情報を設定します。
	 * 
	 * @param id ID
	 * @param message メッセージ
	 */
	protected void setValidateResult(String id, String message) {
		
		this.validateResult = new ValidateResult();
		this.validateResult.setValid(false);
		this.validateResult.setID(id);
		this.validateResult.setMessage(message);
		
	}
	
}