/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import org.postgresforest.Driver;
import org.postgresforest.vm.Lock;
import org.postgresforest.vm.LogUtil;

public abstract class AbstractForestThread
extends Thread {
    protected boolean m_isExecuted = false;
    protected boolean m_runnning;
    protected Lock m_executeSync;
    protected LogUtil m_logUtil;

    public AbstractForestThread(LogUtil logUtil) {
        this.m_logUtil = logUtil;
        this.m_executeSync = new Lock(1);
        this.setDaemon(true);
        this.start();
    }

    protected void waitExecute() {
        while (!this.isExecuted()) {
            try {
                this.m_executeSync.waitEnd();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.waitExecute();
        AbstractForestThread abstractForestThread = this;
        synchronized (abstractForestThread) {
            this.m_isExecuted = false;
            this.m_executeSync.reset(1);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_runnning = true;
        while (this.m_runnning) {
            try {
                if (Driver.logDebug) {
                    this.m_logUtil.debug(this.getName() + ": Waiting for processing...1");
                }
                AbstractForestThread abstractForestThread = this;
                synchronized (abstractForestThread) {
                    this.standby();
                    if (Driver.logDebug) {
                        this.m_logUtil.debug(this.getName() + ": Waiting for processing...2");
                    }
                    this.wait();
                }
                this._execute();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void standby() {
        this.m_isExecuted = true;
        this.m_executeSync.notifyEnd();
    }

    protected abstract void _execute();

    public synchronized boolean isExecuted() {
        return this.m_isExecuted;
    }

    public synchronized void terminate() {
        this.m_runnning = false;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

