/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.clusterconnection;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.transaction.TransactionManager;
import org.jboss.jms.client.JBossConnection;
import org.jboss.jms.client.JBossSession;
import org.jboss.jms.client.container.ClientConsumer;
import org.jboss.jms.client.delegate.ClientConsumerDelegate;
import org.jboss.jms.client.state.ConsumerState;
import org.jboss.jms.delegate.ProducerDelegate;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossQueue;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.message.MessageProxy;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.tm.TransactionManagerLocator;

public class MessageSucker
implements MessageListener {
    private static final Logger log = Logger.getLogger(MessageSucker.class);
    private boolean trace = log.isTraceEnabled();
    private JBossConnection sourceConnection;
    private JBossConnection localConnection;
    private Queue localQueue;
    private SessionDelegate sourceSession;
    private SessionDelegate localSession;
    private ProducerDelegate producer;
    private volatile boolean started;
    private boolean xa;
    private TransactionManager tm;
    private boolean consuming;
    private ClientConsumerDelegate consumer;
    private ClientConsumer clientConsumer;
    private boolean preserveOrdering;
    private long sourceChannelID;

    public String toString() {
        return "MessageSucker:" + System.identityHashCode(this) + " queue:" + this.localQueue.getName();
    }

    MessageSucker(Queue localQueue, JBossConnection sourceConnection, JBossConnection localConnection, boolean xa, boolean preserveOrdering, long sourceChannelID) {
        if (this.trace) {
            log.trace((Object)("Creating message sucker, localQueue:" + localQueue + " xa:" + xa + " preserveOrdering:" + preserveOrdering));
        }
        this.localQueue = localQueue;
        this.sourceConnection = sourceConnection;
        this.localConnection = localConnection;
        this.xa = false;
        this.preserveOrdering = preserveOrdering;
        this.sourceChannelID = sourceChannelID;
        if (xa) {
            this.tm = TransactionManagerLocator.getInstance().locate();
        }
    }

    synchronized void start() throws Exception {
        JBossSession sess;
        if (this.started) {
            return;
        }
        if (this.trace) {
            log.trace((Object)(this + " starting"));
        }
        if (!this.xa) {
            sess = (JBossSession)this.sourceConnection.createSession(false, 2);
            this.sourceSession = sess.getDelegate();
            sess = (JBossSession)this.localConnection.createSession(false, 1);
            this.localSession = sess.getDelegate();
        } else {
            sess = (JBossSession)this.sourceConnection.createXASession();
            this.sourceSession = sess.getDelegate();
            sess = (JBossSession)this.localConnection.createXASession();
            this.localSession = sess.getDelegate();
        }
        JBossQueue dest = new JBossQueue(this.localQueue.getName(), true);
        this.producer = this.localSession.createProducerDelegate(dest);
        this.consumer = (ClientConsumerDelegate)this.sourceSession.createConsumerDelegate(dest, null, false, null, false, false);
        this.clientConsumer = ((ConsumerState)this.consumer.getState()).getClientConsumer();
        this.consumer.setMessageListener(this);
        if (this.trace) {
            log.trace((Object)(this + " Registering sucker"));
        }
        this.localQueue.registerSucker(this);
        this.started = true;
        if (this.trace) {
            log.trace((Object)(this + " Registered sucker"));
        }
    }

    synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.setConsuming(false);
        this.localQueue.unregisterSucker(this);
        try {
            this.sourceSession.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.localSession.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.started = false;
    }

    public String getQueueName() {
        return this.localQueue.getName();
    }

    public synchronized void setConsuming(boolean consume) {
        if (this.trace) {
            log.trace((Object)(this + " setConsuming " + consume));
        }
        try {
            if (consume && !this.consuming) {
                if (this.trace) {
                    log.trace((Object)(this + " resuming client consumer"));
                }
                this.clientConsumer.resume();
                this.consuming = true;
            } else if (!consume && this.consuming) {
                if (this.trace) {
                    log.trace((Object)(this + " pausing client consumer"));
                }
                this.clientConsumer.pause();
                this.consuming = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onMessage(Message msg) {
        block10: {
            Object tx = null;
            if (this.trace) {
                log.trace((Object)(this + " sucked message " + msg));
            }
            try {
                JBossMessage coreMessage = ((MessageProxy)msg).getMessage();
                if (this.preserveOrdering) {
                    coreMessage.putHeader("SUCKED", "x");
                }
                coreMessage.putHeader("SCID", this.sourceChannelID);
                long timeToLive = msg.getJMSExpiration();
                if (timeToLive != 0L && (timeToLive -= System.currentTimeMillis()) <= 0L) {
                    timeToLive = 1L;
                }
                msg.acknowledge();
                if (this.trace) {
                    log.trace((Object)"Acknowledged message");
                }
                this.producer.send(null, msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), timeToLive, true);
                if (this.trace) {
                    log.trace((Object)(this + " forwarded message to queue"));
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to forward message", (Throwable)e);
                try {
                    if (tx != null) {
                        this.tm.rollback();
                    }
                }
                catch (Throwable t) {
                    if (!this.trace) break block10;
                    log.trace((Object)"Failed to rollback tx", t);
                }
            }
        }
    }
}

