/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.http.util;

import com.clustercontrol.util.Messages;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetHttpResponse {
    protected static Log m_log = LogFactory.getLog(GetHttpResponse.class);
    public static final String TARGET_CONTENT_TYPE = "text";
    protected String m_proxyHost;
    protected int m_proxyPort;
    protected int m_statusCode;
    protected StringBuffer m_header;
    protected String m_responseBody;
    protected StringBuffer m_footer;
    protected long m_responseTime;
    protected String m_errorMessage;

    public GetHttpResponse() {
    }

    public GetHttpResponse(String host, int port) {
        this.m_proxyHost = host;
        this.m_proxyPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String url, int timeout) {
        boolean result = false;
        HttpClient client = new HttpClient();
        if (this.m_proxyHost != null && !"".equals(this.m_proxyHost.trim())) {
            client.getHostConfiguration().setProxy(this.m_proxyHost, this.m_proxyPort);
        }
        GetMethod method = new GetMethod(url);
        if (timeout > 0) {
            client.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
            method.getParams().setSoTimeout(timeout);
        }
        try {
            Header[] footers;
            long start = System.currentTimeMillis();
            this.m_statusCode = client.executeMethod((HttpMethod)method);
            long end = System.currentTimeMillis();
            this.m_responseTime = end - start;
            Header[] headers = method.getResponseHeaders();
            if (headers != null && headers.length > 0) {
                this.m_header = new StringBuffer();
                for (int i = 0; i < headers.length; ++i) {
                    this.m_header.append(headers[i]);
                }
            }
            if ((footers = method.getResponseFooters()) != null && footers.length > 0) {
                this.m_header = new StringBuffer();
                for (int i = 0; i < footers.length; ++i) {
                    this.m_footer.append(footers[i]);
                }
            }
            if (this.m_statusCode == 200) {
                Header header = method.getResponseHeader("Content-Type");
                if (header != null && header.getValue() != null && header.getValue().indexOf(TARGET_CONTENT_TYPE) != -1) {
                    InputStreamReader in = new InputStreamReader(method.getResponseBodyAsStream(), "JISAutoDetect");
                    StringBuffer stb = new StringBuffer();
                    int c = 0;
                    while ((c = in.read()) != -1) {
                        stb.append((char)c);
                    }
                    this.m_responseBody = stb.toString();
                    result = true;
                } else {
                    this.m_errorMessage = Messages.getString((String)"message.http.2");
                }
            } else {
                this.m_errorMessage = method.getStatusText();
            }
        }
        catch (UnsupportedEncodingException e) {
            m_log.debug((Object)("execute(): " + e.getMessage()));
            this.m_errorMessage = "UnsupportedEncodingException : " + e.getMessage();
        }
        catch (HttpException e) {
            m_log.debug((Object)("execute(): Fatal protocol violation. " + e.getMessage()));
            this.m_errorMessage = "HttpException : " + e.getMessage();
        }
        catch (IOException e) {
            m_log.debug((Object)("execute(): Fatal transport error. " + e.getMessage()));
            this.m_errorMessage = "IOException : " + e.getMessage();
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    public String getFooter() {
        if (this.m_footer != null) {
            return this.m_footer.toString();
        }
        return null;
    }

    public String getHeader() {
        if (this.m_header != null) {
            return this.m_header.toString();
        }
        return null;
    }

    public String getResponseBody() {
        return this.m_responseBody;
    }

    public long getResponseTime() {
        return this.m_responseTime;
    }

    public int getStatusCode() {
        return this.m_statusCode;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }
}

