/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectSystemNotify {
    protected static Log m_log = LogFactory.getLog(SelectSystemNotify.class);

    public NotifyInfo getNotify(String notifyId) throws FinderException, NamingException {
        NotifyInfo bean = null;
        try {
            SystemNotifyInfoLocal notify = SystemNotifyInfoUtil.getLocalHome().findByPrimaryKey(notifyId);
            ArrayList<NotifyEventInfo> notifyEvents = new ArrayList<NotifyEventInfo>();
            Collection ct = notify.getSystemNotifyEventInfo();
            Iterator itr = ct.iterator();
            SystemNotifyEventInfoLocal local = null;
            while (itr.hasNext()) {
                local = (SystemNotifyEventInfoLocal)itr.next();
                NotifyEventInfo event = new NotifyEventInfo(notifyId, local.getPriority(), local.getEventNormalFlg(), local.getEventNormalState(), local.getEventInhibitionFlg(), local.getEventInhibitionState());
                notifyEvents.add(event);
            }
            bean = new NotifyInfo(notify.getNotifyId(), notify.getDescription(), notify.getNotifyType(), notify.getInhibitionFlg(), notify.getInhibitionFrequency(), notify.getInhibitionPeriod(), notify.getRegDate(), notify.getUpdateDate(), notify.getRegUser(), notify.getUpdateUser(), notify.getValidFlg(), notifyEvents);
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("getNotify():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("getNotify():" + e.getMessage()));
            throw e;
        }
        return bean;
    }

    public ArrayList getNotifyIdList() throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct = SystemNotifyInfoUtil.getLocalHome().findAllOrderByNotifyId();
            Iterator itr = ct.iterator();
            while (itr.hasNext()) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                SystemNotifyInfoLocal notify = (SystemNotifyInfoLocal)itr.next();
                list.add(notify.getNotifyId());
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "005");
            m_log.debug((Object)("getNotifyList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "005");
            m_log.debug((Object)("getNotifyList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    public ArrayList getNotifyList() throws CreateException, FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = SystemNotifyInfoUtil.getLocalHome().findAllOrderByNotifyId();
            list = this.collectionToArray(ct);
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    public HashMap<String, NotifyInfo> getNotifyMap() throws FinderException, NamingException {
        HashMap<String, NotifyInfo> map = new HashMap<String, NotifyInfo>();
        try {
            Collection ct = SystemNotifyInfoUtil.getLocalHome().findAll();
            Iterator itr = ct.iterator();
            SystemNotifyInfoLocal notify = null;
            ArrayList<NotifyEventInfo> notifyEventsList = null;
            Collection ctEvents = null;
            Iterator itrEvents = null;
            SystemNotifyEventInfoLocal local = null;
            while (itr.hasNext()) {
                notify = (SystemNotifyInfoLocal)itr.next();
                ctEvents = notify.getSystemNotifyEventInfo();
                itrEvents = ctEvents.iterator();
                local = null;
                notifyEventsList = new ArrayList<NotifyEventInfo>();
                while (itrEvents.hasNext()) {
                    local = (SystemNotifyEventInfoLocal)itrEvents.next();
                    NotifyEventInfo event = new NotifyEventInfo(local.getNotifyId(), local.getPriority(), local.getEventNormalFlg(), local.getEventNormalState(), local.getEventInhibitionFlg(), local.getEventInhibitionState());
                    notifyEventsList.add(event);
                }
                NotifyInfo bean = new NotifyInfo(notify.getNotifyId(), notify.getDescription(), notify.getNotifyType(), notify.getInhibitionFlg(), notify.getInhibitionFrequency(), notify.getInhibitionPeriod(), notify.getRegDate(), notify.getUpdateDate(), notify.getRegUser(), notify.getUpdateUser(), notify.getValidFlg(), notifyEventsList);
                map.put(notify.getNotifyId(), bean);
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyMap():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyMap():" + e.getMessage()));
            throw e;
        }
        return map;
    }

    private ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, NamingException {
        ArrayList list = new ArrayList();
        for (SystemNotifyInfoLocal notify : ct) {
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(notify.getNotifyId());
            info.add(notify.getDescription());
            info.add(new Boolean(ValidConstant.typeToBoolean((int)notify.getStatusFlg())));
            info.add(new Boolean(ValidConstant.typeToBoolean((int)notify.getEventFlg())));
            info.add(notify.getUpdateDate() == null ? null : new Date(notify.getUpdateDate().getTime()));
            list.add(info);
        }
        return list;
    }
}

