/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteNotifyInhibition {
    protected static Log m_log = LogFactory.getLog(DeleteNotifyInhibition.class);

    public boolean deleteBaseOnNotifyGroupId(String notifyGroupId) throws FinderException, RemoveException, NamingException {
        AccessLock.lock((String)"NOTIFY");
        try {
            Collection inhibits = NotifyActionInhibitionInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
            for (NotifyActionInhibitionInfoLocal detail : inhibits) {
                detail.remove();
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        return true;
    }

    public boolean deleteBaseOnNotifyId(String notifyId) {
        AccessLock.lock((String)"NOTIFY");
        try {
            Collection ct = NotifyActionInhibitionInfoUtil.getLocalHome().findByNotifyId(notifyId);
            for (NotifyActionInhibitionInfoLocal inhibit : ct) {
                inhibit.remove();
            }
        }
        catch (RemoveException e) {
            m_log.debug((Object)("deleteBaseOnNotifyId():" + e.getMessage()));
        }
        catch (FinderException e) {
            m_log.debug((Object)("deleteBaseOnNotifyId():" + e.getMessage()));
        }
        catch (NamingException e) {
            m_log.debug((Object)("deleteBaseOnNotifyId():" + e.getMessage()));
        }
        return true;
    }

    public boolean deleteEvent(String notifyGroupId, String facilityId, Timestamp generationDate, int priority) throws NamingException, EJBException, RemoveException {
        try {
            Collection ctRelation = NotifyRelationInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
            Iterator itrRelation = ctRelation.iterator();
            boolean isDelete = false;
            while (itrRelation.hasNext()) {
                NotifyRelationInfoLocal relation = (NotifyRelationInfoLocal)itrRelation.next();
                if (relation.getNotifyType() != 1) continue;
                String notifyId = relation.getNotifyId();
                NotifyActionInhibitionInfoLocal inhibit = NotifyActionInhibitionInfoUtil.getLocalHome().findByPrimaryKey(new NotifyActionInhibitionInfoPK(notifyGroupId, notifyId, facilityId));
                NotifyEventInfoLocal notifyEventInfo = NotifyEventInfoUtil.getLocalHome().findByPrimaryKey(new NotifyEventInfoPK(notifyId, priority));
                if (notifyEventInfo.getEventInhibitionFlg() == 1) {
                    if (inhibit.getLastNotifyDate().compareTo(generationDate) != 0) continue;
                    isDelete = true;
                    break;
                }
                if (inhibit.getLastUpdateDate().compareTo(generationDate) != 0) continue;
                isDelete = true;
                break;
            }
            if (isDelete) {
                Collection ctInhibit = NotifyActionInhibitionInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
                for (NotifyActionInhibitionInfoLocal inhibit : ctInhibit) {
                    if (!inhibit.getFacilityId().equals(facilityId)) continue;
                    inhibit.remove();
                }
            }
        }
        catch (FinderException e) {
            m_log.debug((Object)"deleteEvent() : \u8a72\u5f53\u306e\u60c5\u5831\u306f\u3042\u308a\u307e\u305b\u3093\u3002", (Throwable)e);
        }
        return true;
    }
}

