/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.OptimisticTreeNode;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;

public class WorkspaceNodeImpl
implements WorkspaceNode {
    private static Log log = LogFactory.getLog((Class)WorkspaceNodeImpl.class);
    private DataNode node;
    private TransactionWorkspace workspace;
    private DataVersion version = DefaultDataVersion.ZERO;
    private boolean deleted;
    private boolean modified;
    private boolean created;
    private Map optimisticChildNodeMap;
    private Map optimisticDataMap;
    private boolean versioningImplicit = true;
    private boolean childrenModified;
    private Set childrenAdded = new HashSet();
    private Set childrenRemoved = new HashSet();
    private static boolean trace = log.isTraceEnabled();

    public WorkspaceNodeImpl() {
        this(new OptimisticTreeNode(), null);
    }

    public WorkspaceNodeImpl(TreeNode node, TransactionWorkspace workspace) {
        this((DataNode)node, workspace);
    }

    public WorkspaceNodeImpl(DataNode node, TransactionWorkspace workspace) {
        if (!(node instanceof OptimisticTreeNode)) {
            throw new IllegalArgumentException("node " + node + " not OptimisticTreeNode");
        }
        this.node = node;
        this.workspace = workspace;
        this.optimisticDataMap = node.getData();
        if (this.optimisticDataMap == null) {
            this.optimisticDataMap = new HashMap();
        }
        this.optimisticChildNodeMap = node.getChildren() == null ? Collections.EMPTY_MAP : new ConcurrentReaderHashMap(node.getChildren());
        this.version = ((OptimisticTreeNode)node).getVersion();
    }

    public boolean isChildrenModified() {
        return this.childrenModified;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isDirty() {
        return this.modified || this.created || this.deleted;
    }

    public Fqn getFqn() {
        return this.node.getFqn();
    }

    public void put(Map data, boolean eraseData) {
        this.realPut(data, eraseData);
        this.modified = true;
    }

    public void put(Map data) {
        this.realPut(data, false);
        this.modified = true;
    }

    public Object put(Object key, Object value) {
        this.modified = true;
        return this.optimisticDataMap.put(key, value);
    }

    public Object remove(Object key) {
        this.modified = true;
        return this.optimisticDataMap.remove(key);
    }

    public void clear() {
        this.optimisticDataMap.clear();
        this.modified = true;
    }

    public Object get(Object key) {
        return this.optimisticDataMap.get(key);
    }

    public Set getKeys() {
        return this.optimisticDataMap.keySet();
    }

    public Set getChildrenNames() {
        return new HashSet(this.optimisticChildNodeMap.keySet());
    }

    private void realPut(Map data, boolean eraseData) {
        this.realPut(data, eraseData, true);
    }

    private void realPut(Map data, boolean eraseData, boolean forceDirtyFlag) {
        if (forceDirtyFlag) {
            this.modified = true;
        }
        if (eraseData) {
            this.optimisticDataMap.clear();
        }
        if (data != null) {
            this.optimisticDataMap.putAll(data);
        }
    }

    public void removeChild(Object childName) {
        this.childrenModified = true;
        Object child = this.optimisticChildNodeMap.remove(childName);
        if (trace) {
            log.trace((Object)("Removing child " + childName));
        }
        if (child != null) {
            this.childrenRemoved.add(child);
            this.childrenAdded.remove(child);
        }
    }

    public TreeNode getParent() {
        return this.node.getParent();
    }

    public TreeNode getWrappedParent() {
        WorkspaceNode workspaceNode = this.workspace.getNode(this.node.getParent().getFqn());
        if (workspaceNode == null) {
            workspaceNode = NodeFactory.getInstance().createWorkspaceNode(this.node.getParent(), this.workspace);
            this.workspace.addNode(workspaceNode);
        }
        return workspaceNode;
    }

    public TreeNode createChild(Object child_name, Fqn fqn, TreeNode parent) {
        log.error((Object)"Not implemented here!!");
        return null;
    }

    public TreeNode createChild(Object child_name, Fqn fqn, TreeNode parent, TreeCache cache, DataVersion version) {
        if (child_name == null) {
            return null;
        }
        TreeNode child = (TreeNode)this.optimisticChildNodeMap.get(child_name);
        if (child == null) {
            child = NodeFactory.getInstance().createNodeOfType(parent, child_name, fqn, parent, null, cache, version);
            if (this.optimisticChildNodeMap == Collections.EMPTY_MAP) {
                this.optimisticChildNodeMap = new ConcurrentReaderHashMap();
            }
            this.optimisticChildNodeMap.put(child_name, child);
            if (trace) {
                log.trace((Object)("Adding child " + child_name));
            }
            this.childrenAdded.add(child);
            this.childrenRemoved.remove(child);
        }
        this.childrenModified = true;
        if (trace) {
            log.trace((Object)("createChild: fqn=" + fqn + " for node " + this));
        }
        return child;
    }

    public boolean isVersioningImplicit() {
        return this.versioningImplicit;
    }

    public void setVersioningImplicit(boolean b) {
        this.versioningImplicit = b;
    }

    public TreeNode getChild(Object childName) {
        return (TreeNode)this.optimisticChildNodeMap.get(childName);
    }

    public TreeNode getWrappedChild(Object fqn) {
        DataNode temp;
        WorkspaceNode wrapper = this.workspace.getNode((Fqn)fqn);
        if (wrapper == null && (temp = (DataNode)this.optimisticChildNodeMap.get(fqn)) != null) {
            wrapper = new WorkspaceNodeImpl(temp, this.workspace);
            this.workspace.addNode(wrapper);
        }
        return wrapper;
    }

    public DataNode getNode() {
        return this.node;
    }

    public DataVersion getVersion() {
        return this.version;
    }

    public void setVersion(DataVersion version) {
        this.version = version;
    }

    public List getMergedChildren() {
        ArrayList<Set> l = new ArrayList<Set>(2);
        l.add(this.childrenAdded);
        l.add(this.childrenRemoved);
        return l;
    }

    public Map getMergedData() {
        return this.optimisticDataMap;
    }

    public void markAsDeleted(boolean marker) {
        this.markAsDeleted(marker, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsDeleted(boolean marker, boolean recursive) {
        this.deleted = marker;
        if (recursive && this.optimisticChildNodeMap != null) {
            WorkspaceNodeImpl workspaceNodeImpl = this;
            synchronized (workspaceNodeImpl) {
                Collection values = this.optimisticChildNodeMap.values();
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    ((WorkspaceNodeImpl)it.next()).markAsDeleted(marker, true);
                }
            }
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Object getName() {
        return this.node.getName();
    }

    public TransactionWorkspace getTransactionWorkspace() {
        return this.workspace;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void markAsCreated() {
        this.created = true;
    }

    public Map getData() {
        return null;
    }

    public Map getChildren() {
        return null;
    }

    public boolean containsKey(Object key) {
        return false;
    }

    public Set getDataKeys() {
        return null;
    }

    public boolean childExists(Object child_name) {
        return false;
    }

    public IdentityLock getImmutableLock() {
        return null;
    }

    public IdentityLock getLock() {
        return null;
    }

    public int numAttributes() {
        return 0;
    }

    public boolean hasChildren() {
        return false;
    }

    public TreeNode getOrCreateChild(Object child_name, GlobalTransaction gtx, boolean createIfNotExists) {
        return null;
    }

    public TreeNode createChild(Object child_name, Fqn fqn, TreeNode parent, Object key, Object value) {
        return null;
    }

    public void removeAllChildren() {
    }

    public void print(StringBuffer sb, int indent) {
    }

    public void printDetails(StringBuffer sb, int indent) {
    }

    public void printIndent(StringBuffer sb, int indent) {
    }

    public void addChild(Object child_name, TreeNode n) {
    }

    public void printLockInfo(StringBuffer sb, int indent) {
    }

    public boolean isLocked() {
        return false;
    }

    public void releaseAll(Object owner) {
    }

    public void releaseAllForce() {
    }

    public Set acquireAll(Object caller, long timeout, int lock_type) throws LockingException, TimeoutException, InterruptedException {
        return null;
    }

    public void setRecursiveTreeCacheInstance(TreeCache cache) {
    }

    public boolean getChildrenLoaded() {
        return false;
    }

    public void setChildrenLoaded(boolean b) {
    }

    public void setChildren(Map children) {
    }

    public void release(Object caller) {
    }

    public void releaseForce() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.deleted) {
            sb.append("del ");
        }
        if (this.modified) {
            sb.append("modified ");
        }
        if (this.created) {
            sb.append("new ");
        }
        return "WorkNode fqn=" + this.getFqn() + " " + sb + "ver=" + this.version;
    }

    public void addChild(WorkspaceNode child) {
        if (trace) {
            log.trace((Object)("Adding child " + child.getName()));
        }
        this.optimisticChildNodeMap.put(child.getName(), child.getNode());
        this.childrenAdded.add(child.getNode());
        this.childrenRemoved.remove(child.getNode());
        this.childrenModified = true;
    }
}

