/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.LeasePinger;
import org.jboss.remoting.loading.ClassByteClassLoader;
import org.jboss.remoting.loading.RemotingClassLoader;
import org.jboss.remoting.marshal.InvalidMarshallingResource;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.util.id.GUID;

public abstract class MicroRemoteClientInvoker
extends AbstractInvoker
implements ClientInvoker {
    private static final Logger log = Logger.getLogger(MicroRemoteClientInvoker.class);
    private boolean trace = log.isTraceEnabled();
    protected boolean connected = false;
    private Marshaller marshaller;
    private UnMarshaller unmarshaller;
    private String dataType;
    private final Object clientLeaseLock = new Object();
    private LeasePinger leasePinger = null;
    private String invokerSessionID = new GUID().toString();

    public MicroRemoteClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    public MicroRemoteClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public Object invoke(InvocationRequest invocationReq) throws Throwable {
        Object returnValue = null;
        int invokeCount = 0;
        if (this.trace) {
            log.trace(this + "(" + ++invokeCount + ") invoking " + invocationReq);
        }
        Marshaller marshaller = this.getMarshaller();
        UnMarshaller unmarshaller = this.getUnMarshaller();
        if (marshaller == null && (marshaller = MarshalFactory.getMarshaller(this.getLocator(), this.getClassLoader())) == null) {
            marshaller = MarshalFactory.getMarshaller(this.getDataType(), this.getSerializationType());
            if (marshaller == null) {
                throw new InvalidMarshallingResource("Can not find a valid marshaller for data type: " + this.getDataType());
            }
            this.setMarshaller(marshaller);
        }
        if (unmarshaller == null) {
            RemotingClassLoader remotingClassLoader = new RemotingClassLoader(this.getClassLoader(), Thread.currentThread().getContextClassLoader());
            unmarshaller = MarshalFactory.getUnMarshaller(this.getLocator(), this.getClassLoader());
            if (unmarshaller == null) {
                unmarshaller = MarshalFactory.getUnMarshaller(this.getDataType(), this.getSerializationType());
                if (unmarshaller == null) {
                    throw new InvalidMarshallingResource("Can not find a valid unmarshaller for data type: " + this.getDataType());
                }
                this.setUnMarshaller(unmarshaller);
            }
            unmarshaller.setClassLoader(remotingClassLoader);
        }
        Object payload = null;
        Map metadata = invocationReq.getRequestPayload();
        payload = metadata != null && metadata.get("rawPayload") != null ? invocationReq.getParameter() : invocationReq;
        returnValue = this.transport(invocationReq.getSessionId(), payload, metadata, marshaller, unmarshaller);
        if (returnValue instanceof InvocationResponse) {
            InvocationResponse response = (InvocationResponse)returnValue;
            returnValue = response.getResult();
            if (response.isException()) {
                StackTraceElement[] serverStackTrace;
                Throwable e = (Throwable)returnValue;
                if (this.trace) {
                    log.trace(this + " received a server-side exception as response to the invocation: " + e);
                }
                if (e.getCause() != null) {
                    serverStackTrace = e.getCause().getStackTrace();
                    if (serverStackTrace == null || serverStackTrace.length == 0) {
                        serverStackTrace = e.getStackTrace();
                    }
                } else {
                    serverStackTrace = e.getStackTrace();
                }
                if (serverStackTrace == null || serverStackTrace.length == 0) {
                    log.warn("An exception occurred on the server side when making remote invocation.  The exception returned from server does not include a stack trace.  Original server side exception message is " + e.getMessage(), e);
                }
                Exception clientException = new Exception();
                StackTraceElement[] clientStackTrace = clientException.getStackTrace();
                StackTraceElement[] completeStackTrace = new StackTraceElement[serverStackTrace.length + clientStackTrace.length];
                System.arraycopy(serverStackTrace, 0, completeStackTrace, 0, serverStackTrace.length);
                System.arraycopy(clientStackTrace, 0, completeStackTrace, serverStackTrace.length, clientStackTrace.length);
                if (e.getCause() != null) {
                    e.getCause().setStackTrace(completeStackTrace);
                } else {
                    e.setStackTrace(completeStackTrace);
                }
                throw e;
            }
            if (this.trace) {
                log.trace(this + " received InvocationResponse so going to return response's return value of " + returnValue);
            }
        }
        return returnValue;
    }

    protected void preProcess(String sessionId, Object param, Map sendPayload, Map receivedPayload) {
    }

    protected void postProcess(String sessionId, Object param, Map sendPayload, Map receivedPayload) {
    }

    protected abstract Object transport(String var1, Object var2, Map var3, Marshaller var4, UnMarshaller var5) throws IOException, ConnectionFailedException, ClassNotFoundException;

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void connect() throws ConnectionFailedException {
        if (!this.connected) {
            log.debug(this + " connecting");
            this.handleConnect();
            this.connected = true;
            log.debug(this + " connected");
        }
    }

    protected abstract void handleConnect() throws ConnectionFailedException;

    protected abstract void handleDisconnect();

    public synchronized void disconnect() {
        if (this.trace) {
            log.trace(this + " disconnecting ...");
        }
        if (this.connected) {
            this.connected = false;
            this.handleDisconnect();
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader != null && classLoader instanceof ClassByteClassLoader) {
                this.classbyteloader.destroy();
            }
            if (this.trace) {
                log.trace(this + " disconnected");
            }
        } else if (this.trace) {
            log.trace(this + " is not connected!");
        }
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setUnMarshaller(UnMarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public UnMarshaller getUnMarshaller() {
        return this.unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateLease(String sessionId, int disconnectTimeout) {
        Object object = this.clientLeaseLock;
        synchronized (object) {
            if (this.leasePinger != null) {
                this.leasePinger.setDisconnectTimeout(disconnectTimeout);
                boolean isLastClientLease = this.leasePinger.removeClient(sessionId);
                if (isLastClientLease) {
                    try {
                        this.leasePinger.stopPing();
                    }
                    catch (Exception e) {
                        log.error("error shutting down lease pinger");
                    }
                    this.leasePinger = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLeasePeriod(String sessionID) {
        Object object = this.clientLeaseLock;
        synchronized (object) {
            if (this.leasePinger == null) {
                return -1L;
            }
            return this.leasePinger.getLeasePeriod(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establishLease(String clientSessionID, Map configuration, long leasePeriod) throws Throwable {
        Object object = this.clientLeaseLock;
        synchronized (object) {
            if (this.leasePinger != null) {
                this.leasePinger.addClient(clientSessionID, configuration, leasePeriod);
                log.debug(this + " added client with session ID " + clientSessionID + " to the lease pinger");
                return;
            }
            try {
                InvocationResponse resp;
                Boolean shouldLease;
                InvocationRequest ir;
                Object ret;
                if (this.trace) {
                    log.trace(this + " sending initial lease ping to server to determine if server has leasing enabled.");
                }
                if ((ret = this.invoke(ir = new InvocationRequest(this.invokerSessionID, null, "$PING$", null, new HashMap(), null))) instanceof InvocationResponse && (shouldLease = (Boolean)(resp = (InvocationResponse)ret).getResult()).booleanValue()) {
                    Long leaseTimeoutValue;
                    long serverDefaultLeasePeriod;
                    long defaultLeasePeriod = 5000L;
                    Map respMap = resp.getPayload();
                    if (respMap != null && (serverDefaultLeasePeriod = (leaseTimeoutValue = (Long)respMap.get("clientLeasePeriod")).longValue()) > 0L) {
                        defaultLeasePeriod = serverDefaultLeasePeriod;
                    }
                    if (this.trace) {
                        log.trace("server does have leasing enabled (with default lease period of " + defaultLeasePeriod + ") and will start a new lease pinger.");
                    }
                    this.leasePinger = new LeasePinger(this, this.invokerSessionID, defaultLeasePeriod);
                    this.leasePinger.addClient(clientSessionID, configuration, leasePeriod);
                    this.leasePinger.startPing();
                }
            }
            catch (Throwable throwable) {
                Exception e = new Exception("Error setting up client lease");
                e.initCause(throwable);
                throw e;
            }
        }
    }

    private String getDataType() {
        if (this.dataType == null) {
            this.dataType = this.getDataType(this.getLocator());
            if (this.dataType == null) {
                this.dataType = this.getDefaultDataType();
            }
        }
        return this.dataType;
    }

    private String getDataType(InvokerLocator locator) {
        Map params;
        String type = null;
        if (locator != null && (params = locator.getParameters()) != null && (type = (String)params.get("datatype")) == null) {
            type = (String)params.get("dataType");
        }
        return type;
    }

    protected abstract String getDefaultDataType();

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }
}

