/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.asynch.AsynchMixin;
import org.jboss.aspects.asynch.AsynchProvider;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.remoting.BaseRemoteProxy;
import org.jboss.ejb3.stateful.ForwardId;
import org.jboss.ejb3.stateful.StatefulRemoteInvocation;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.util.id.GUID;

public class StatefulClusteredProxy
extends BaseRemoteProxy {
    private static final long serialVersionUID = -1797802577940671292L;
    private Object id;
    protected FamilyWrapper family;
    protected LoadBalancePolicy lbPolicy;
    AsynchProvider provider;
    protected String partitionName;

    public StatefulClusteredProxy(Container container, Interceptor[] interceptors, FamilyWrapper family, LoadBalancePolicy lb, String partitionName) {
        super(container, interceptors);
        this.family = family;
        this.lbPolicy = lb;
        this.partitionName = partitionName;
    }

    public StatefulClusteredProxy(AsynchProvider provider, String containerId, String containerGuid, Interceptor[] interceptors, FamilyWrapper family, LoadBalancePolicy lb, String partitionName) {
        super(containerId, containerGuid, interceptors);
        this.provider = provider;
        this.family = family;
        this.lbPolicy = lb;
        this.partitionName = partitionName;
    }

    protected StatefulClusteredProxy() {
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == AsynchProvider.class) {
            return this.provider.getFuture();
        }
        long hash = MethodHashing.calculateHash(method);
        Object ret = ProxyUtils.handleCallLocally(hash, (JBossProxy)proxy, this, method, args);
        if (ret != null) {
            return ret;
        }
        StatefulRemoteInvocation sri = new StatefulRemoteInvocation(this.interceptors, hash, method, method, null, this.id);
        sri.setArguments(args);
        sri.setInstanceResolver(this.metadata);
        sri.getMetaData().addMetaData("DISPATCHER", "OID", this.containerId, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILY_WRAPPER", this.family, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData("CLUSTERED_REMOTING", "LOADBALANCE_POLICY", this.lbPolicy, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
        sri.getMetaData().addMetaData("PARTITION_NAME", "PARTITION_NAME", this.partitionName, PayloadKey.TRANSIENT);
        sri.getMetaData().addMetaData("IS_LOCAL", "GUID", this.containerGuid, PayloadKey.AS_IS);
        if (this.provider != null) {
            sri.getMetaData().addMetaData("ASYNCH", "INVOKE_ASYNCH", "YES", PayloadKey.AS_IS);
        }
        try {
            Object rtn = sri.invokeNext();
            if (this.id == null) {
                this.id = sri.getResponseAttachment("NEW_ID");
            }
            return rtn;
        }
        catch (ForwardId forward) {
            this.id = forward.getId();
            throw forward.getCause();
        }
    }

    public Object getAsynchronousProxy(Object proxy) {
        Class[] infs = proxy.getClass().getInterfaces();
        if (!ProxyUtils.isAsynchronous(infs)) {
            Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
            AsynchMixin mixin = new AsynchMixin();
            Interceptor[] newInterceptors = ProxyUtils.addAsynchProxyInterceptor(mixin, this.interceptors);
            StatefulClusteredProxy handler = new StatefulClusteredProxy(mixin, this.containerId, this.containerGuid, newInterceptors, this.family, this.lbPolicy, this.partitionName);
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return proxy;
    }

    public String toString() {
        if (this.id != null) {
            return this.containerId.toString() + ":" + this.id.toString();
        }
        GUID guid = new GUID();
        return this.containerId.toString() + ":" + guid.toString();
    }
}

