/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class AttributeOperationResolver {
    private Node opRoot = null;
    private Node atRoot = null;

    public AttributeOperationResolver() {
    }

    public AttributeOperationResolver(MBeanInfo info) {
        this(info.getAttributes(), info.getOperations());
    }

    public AttributeOperationResolver(MBeanAttributeInfo[] attributes, MBeanOperationInfo[] operations) {
        int attributeCount = attributes != null ? attributes.length : 0;
        for (int i = 0; i < attributeCount; ++i) {
            this.store(attributes[i].getName(), new Integer(i));
        }
        int operationCount = operations != null ? operations.length : 0;
        for (int i = 0; i < operationCount; ++i) {
            MBeanOperationInfo operation = operations[i];
            MBeanParameterInfo[] params = operation.getSignature();
            String[] signature = new String[params.length];
            for (int j = 0; j < signature.length; ++j) {
                signature[j] = params[j].getType();
            }
            this.store(operation.getName(), signature, new Integer(i));
        }
    }

    public Integer lookup(String actionName, String[] signature) {
        String word = actionName;
        int wordh = word.hashCode();
        int wordpos = -1;
        int maxword = signature != null ? signature.length : 0;
        Node node = this.opRoot;
        Integer rval = null;
        block0: while (node != null) {
            if (wordh < node.hash) {
                node = node.loKid;
                continue;
            }
            if (wordh > node.hash) {
                node = node.hiKid;
                continue;
            }
            for (int i = node.eqKid.length - 1; i > -1; --i) {
                if (!word.equals(node.eqKid[i].val)) continue;
                if (++wordpos < maxword) {
                    node = node.eqKid[i];
                    word = signature[wordpos];
                    wordh = word.hashCode();
                    continue block0;
                }
                rval = node.eqKid[i].code;
                break block0;
            }
        }
        return rval;
    }

    public Integer lookup(String attrName) {
        int attrh = attrName.hashCode();
        Node node = this.atRoot;
        Integer rval = null;
        block0: while (node != null) {
            if (attrh < node.hash) {
                node = node.loKid;
                continue;
            }
            if (attrh > node.hash) {
                node = node.hiKid;
                continue;
            }
            for (int i = node.eqKid.length - 1; i > -1; --i) {
                if (!attrName.equals(node.eqKid[i].val)) continue;
                rval = node.eqKid[i].code;
                break block0;
            }
        }
        return rval;
    }

    public void store(String mname, String[] signature, Integer code) {
        if (this.opRoot == null) {
            this.opRoot = this.createNode(mname);
            this.createValueNode(this.opRoot, mname);
        }
        int word = -1;
        int maxword = signature != null ? signature.length : 0;
        Node current = this.createOrGetNode(this.opRoot, mname);
        while (++word < maxword) {
            current = this.createOrGetNode(current, signature[word]);
        }
        current.code = code;
    }

    public void store(String attrName, Integer code) {
        Node current = null;
        if (this.atRoot == null) {
            this.atRoot = this.createNode(attrName);
            current = this.createValueNode(this.atRoot, attrName);
        } else {
            current = this.createOrGetNode(this.atRoot, attrName);
        }
        current.code = code;
    }

    protected Node createNode(String key) {
        Node h = new Node();
        h.hash = key.hashCode();
        h.val = key;
        return h;
    }

    protected Node createValueNode(Node parent, String key) {
        Node h = new Node();
        h.val = key;
        h.hash = key.hashCode();
        int insertAt = 0;
        if (parent.eqKid == null) {
            parent.eqKid = new Node[1];
        } else {
            Node[] old = parent.eqKid;
            insertAt = old.length;
            parent.eqKid = new Node[insertAt + 1];
            System.arraycopy(old, 0, parent.eqKid, 0, insertAt);
        }
        parent.eqKid[insertAt] = h;
        return h;
    }

    protected Node createOrGetNode(Node parent, String key) {
        Node realParent = parent;
        int keycode = key.hashCode();
        while (true) {
            if (keycode < realParent.hash) {
                if (realParent.loKid == null) {
                    realParent.loKid = this.createNode(key);
                    return this.createValueNode(realParent.loKid, key);
                }
                realParent = realParent.loKid;
                continue;
            }
            if (keycode <= realParent.hash) break;
            if (realParent.hiKid == null) {
                realParent.hiKid = this.createNode(key);
                return this.createValueNode(realParent.hiKid, key);
            }
            realParent = realParent.hiKid;
        }
        if (realParent.eqKid != null) {
            for (int i = 0; i < realParent.eqKid.length; ++i) {
                if (!key.equals(realParent.eqKid[i].val)) continue;
                return realParent.eqKid[i];
            }
        }
        return this.createValueNode(realParent, key);
    }

    public static class Node {
        public int hash = 0;
        public String val = null;
        public Node hiKid = null;
        public Node loKid = null;
        public Node[] eqKid = null;
        public Integer code = null;
    }
}

