/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.jboss.web.tomcat.service.session.JBossCacheClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManager;

class SessionBasedClusteredSession
extends JBossCacheClusteredSession {
    static final long serialVersionUID = 3200976125245487256L;
    protected static final String info = "SessionBasedClusteredSession/1.0";

    public SessionBasedClusteredSession(JBossCacheManager manager) {
        super(manager);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SessionBasedClusteredSession[");
        sb.append(super.toString());
        sb.append("]");
        return sb.toString();
    }

    public void removeMyself() {
        this.proxy_.removeSession(this.realId);
    }

    public void removeMyselfLocal() {
        this.proxy_.removeSessionLocal(this.realId);
    }

    protected void populateAttributes() {
    }

    protected Object getJBossInternalAttribute(String name) {
        Object result = this.attributes.get(name);
        if (this.isGetDirty(result)) {
            this.sessionAttributesDirty();
        }
        return result;
    }

    protected Object removeJBossInternalAttribute(String name, boolean localCall, boolean localOnly) {
        if (localCall) {
            this.sessionAttributesDirty();
        }
        return this.attributes.remove(name);
    }

    protected Map getJBossInternalAttributes() {
        return this.attributes;
    }

    protected Object setJBossInternalAttribute(String name, Object value) {
        this.sessionAttributesDirty();
        return this.attributes.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        SessionBasedClusteredSession sessionBasedClusteredSession = this;
        synchronized (sessionBasedClusteredSession) {
            super.readExternal(in);
            this.attributes = (Map)in.readObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        SessionBasedClusteredSession sessionBasedClusteredSession = this;
        synchronized (sessionBasedClusteredSession) {
            super.writeExternal(out);
            Map excluded = SessionBasedClusteredSession.removeExcludedAttributes(this.attributes);
            out.writeObject(this.attributes);
            if (excluded != null) {
                this.attributes.putAll(excluded);
            }
        }
    }

    public boolean getReplicateSessionBody() {
        return this.isSessionDirty() || this.getExceedsMaxUnreplicatedInterval();
    }
}

