/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMPolicyReader
implements PolicyReader {
    public static final String XMLNS_NS_URI = "http://www.w3.org/2000/xmlns/";

    DOMPolicyReader() {
    }

    public Policy readPolicy(InputStream in) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            Element element = doc.getDocumentElement();
            return this.readPolicy(element);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException("error : " + e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new RuntimeException("error : " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error : " + e.getMessage());
        }
    }

    private Assertion readAssertion(Element element) {
        String namespace = element.getNamespaceURI();
        String localName = element.getLocalName();
        if (!namespace.equals("http://schemas.xmlsoap.org/ws/2004/09/policy")) {
            return this.readPrimitiveAssertion(element);
        }
        if (localName.equals("Policy")) {
            return this.readPolicy(element);
        }
        if (localName.equals("All")) {
            return this.readAndComposite(element);
        }
        if (localName.equals("ExactlyOne")) {
            return this.readXorComposite(element);
        }
        if (localName.equals("PolicyReference")) {
            return this.readPolicyReference(element);
        }
        throw new RuntimeException("unknown element ..");
    }

    public Policy readPolicy(Element element) {
        Policy policy = new Policy();
        Attr attri = element.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (attri != null) {
            policy.setId(attri.getValue());
        }
        if ((attri = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "base")) != null) {
            policy.setBase(attri.getValue());
        }
        policy.addTerms(this.readTerms(element));
        return policy;
    }

    private AndCompositeAssertion readAndComposite(Element element) {
        AndCompositeAssertion andCompositeAssertion = new AndCompositeAssertion();
        andCompositeAssertion.addTerms(this.readTerms(element));
        return andCompositeAssertion;
    }

    private XorCompositeAssertion readXorComposite(Element element) {
        XorCompositeAssertion xorCompositeAssertion = new XorCompositeAssertion();
        xorCompositeAssertion.addTerms(this.readTerms(element));
        return xorCompositeAssertion;
    }

    public PolicyReference readPolicyReference(Element element) {
        Attr attribute = element.getAttributeNode("URI");
        return new PolicyReference(attribute.getValue());
    }

    private PrimitiveAssertion readPrimitiveAssertion(Element element) {
        QName qname = new QName(element.getNamespaceURI(), element.getLocalName(), element.getPrefix());
        PrimitiveAssertion result = new PrimitiveAssertion(qname);
        result.setAttributes(this.getAttributes(element));
        String isOptional = result.getAttribute(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Optional"));
        result.setOptional(new Boolean(isOptional));
        NodeList list = element.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            String strValue;
            Node node = list.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element childElement = (Element)node;
                if (childElement.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/09/policy") && childElement.getLocalName().equals("Policy")) {
                    Policy policy = this.readPolicy(childElement);
                    result.addTerm(policy);
                    continue;
                }
                PrimitiveAssertion pa = this.readPrimitiveAssertion(childElement);
                result.addTerm(pa);
                continue;
            }
            if (nodeType != 3 || (strValue = node.getNodeValue()) == null || strValue.length() == 0) continue;
            result.setStrValue(strValue);
        }
        return result;
    }

    private ArrayList readTerms(Element element) {
        ArrayList<Assertion> terms = new ArrayList<Assertion>();
        NodeList list = element.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node obj = list.item(i);
            if (!(obj instanceof Element)) continue;
            Element e = (Element)obj;
            terms.add(this.readAssertion(e));
        }
        return terms;
    }

    private Hashtable getAttributes(Element element) {
        Hashtable<QName, String> attributes = new Hashtable<QName, String>();
        NamedNodeMap map = element.getAttributes();
        int length = map.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)map.item(i);
            if (XMLNS_NS_URI.equals(attribute.getNamespaceURI())) continue;
            String prefix = attribute.getPrefix();
            QName qn = null;
            qn = prefix != null ? new QName(attribute.getNamespaceURI(), attribute.getLocalName(), prefix) : new QName(attribute.getNamespaceURI(), attribute.getLocalName());
            attributes.put(qn, attribute.getValue());
        }
        return attributes;
    }
}

