/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.snmptrap.dao.SnmpTrapOidInfoDAO;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoBean;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SnmpTrapOidInfoDAOImpl
implements SnmpTrapOidInfoDAO {
    protected static Log m_log = LogFactory.getLog(SnmpTrapOidInfoDAOImpl.class);

    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(SnmpTrapOidInfoPK pk, SnmpTrapOidInfoBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_snmp_trap_oid_info WHERE monitor_id = ? AND mib = ? AND trap_oid = ? AND generic_id = ? AND specific_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.monitorId);
                stmt.setString(2, pk.mib);
                stmt.setString(3, pk.trapOid);
                stmt.setInt(4, pk.genericId);
                stmt.setInt(5, pk.specificId);
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "SnmpTrapOidInfo data is not found.";
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setMonitorId(res.getString("monitor_id"));
                ejb.setMib(res.getString("mib"));
                ejb.setTrapOid(res.getString("trap_oid"));
                ejb.setGenericId(res.getInt("generic_id"));
                ejb.setSpecificId(res.getInt("specific_id"));
                ejb.setValidFlg(res.getInt("valid_flg"));
                ejb.setPriority(res.getInt("priority"));
                ejb.setLogmsg(res.getString("logmsg"));
                ejb.setDescr(res.getString("descr"));
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(SnmpTrapOidInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_snmp_trap_oid_info SET ");
                sql.append("valid_flg = ?, ");
                sql.append("priority = ?, ");
                sql.append("logmsg = ?, ");
                sql.append("descr = ?");
                sql.append("WHERE monitor_id = ? AND ");
                sql.append("mib = ? AND ");
                sql.append("trap_oid = ? AND ");
                sql.append("generic_id = ? AND ");
                sql.append("specific_id = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setInt(1, ejb.getValidFlg());
                stmt.setInt(2, ejb.getPriority());
                stmt.setString(3, ejb.getLogmsg());
                stmt.setString(4, ejb.getDescr());
                stmt.setString(5, ejb.getMonitorId());
                stmt.setString(6, ejb.getMib());
                stmt.setString(7, ejb.getTrapOid());
                stmt.setInt(8, ejb.getGenericId());
                stmt.setInt(9, ejb.getSpecificId());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException"));
                e.printStackTrace();
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException"));
                e1.printStackTrace();
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException"));
            e1.printStackTrace();
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(SnmpTrapOidInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_snmp_trap_oid_info WHERE monitor_id = ? AND mib = ? AND trap_oid = ? AND generic_id = ? AND specific_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.monitorId);
                stmt.setString(2, pk.mib);
                stmt.setString(3, pk.trapOid);
                stmt.setInt(4, pk.genericId);
                stmt.setInt(5, pk.specificId);
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnmpTrapOidInfoPK create(SnmpTrapOidInfoBean ejb) throws CreateException, EJBException {
        SnmpTrapOidInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_snmp_trap_oid_info (");
                sql.append("monitor_id, ");
                sql.append("mib, ");
                sql.append("trap_oid, ");
                sql.append("generic_id, ");
                sql.append("specific_id, ");
                sql.append("valid_flg, ");
                sql.append("priority, ");
                sql.append("logmsg, ");
                sql.append("descr )");
                sql.append("values (?,?,?,?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getMonitorId());
                stmt.setString(2, ejb.getMib());
                stmt.setString(3, ejb.getTrapOid());
                stmt.setInt(4, ejb.getGenericId());
                stmt.setInt(5, ejb.getSpecificId());
                stmt.setInt(6, ejb.getValidFlg());
                stmt.setInt(7, ejb.getPriority());
                stmt.setString(8, ejb.getLogmsg());
                stmt.setString(9, ejb.getDescr());
                int row = stmt.executeUpdate();
                pk = new SnmpTrapOidInfoPK(ejb.getMonitorId(), ejb.getMib(), ejb.getTrapOid(), ejb.getGenericId(), ejb.getSpecificId());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId()));
        return pk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<SnmpTrapOidInfoPK> ret = new ArrayList<SnmpTrapOidInfoPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_snmp_trap_oid_info";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    SnmpTrapOidInfoPK pk = new SnmpTrapOidInfoPK(res.getString("monitor_id"), res.getString("mib"), res.getString("trap_oid"), res.getInt("generic_id"), res.getInt("specific_id"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public SnmpTrapOidInfoPK findByPrimaryKey(SnmpTrapOidInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_snmp_trap_oid_info WHERE monitor_id = ? AND mib = ? AND trap_oid = ? AND generic_id = ? AND specific_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.monitorId);
            stmt.setString(2, pk.mib);
            stmt.setString(3, pk.trapOid);
            stmt.setInt(4, pk.genericId);
            stmt.setInt(5, pk.specificId);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            SnmpTrapOidInfoPK snmpTrapOidInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return snmpTrapOidInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByMonitorId(String monitorId) throws FinderException {
        m_log.debug((Object)"findByMonitorId() start : ");
        ArrayList<SnmpTrapOidInfoPK> ret = new ArrayList<SnmpTrapOidInfoPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_snmp_trap_oid_info WHERE monitor_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, monitorId);
                res = stmt.executeQuery();
                while (res.next()) {
                    SnmpTrapOidInfoPK pk = new SnmpTrapOidInfoPK(res.getString("monitor_id"), res.getString("mib"), res.getString("trap_oid"), res.getInt("generic_id"), res.getInt("specific_id"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findByMonitorId() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findByMonitorId() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findByMonitorId() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findByMonitorId() end : ");
        return ret;
    }
}

