/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.asf;

import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.jms.asf.ServerSessionPoolFactory;
import org.jboss.jms.asf.ServerSessionPoolLoaderMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.util.naming.NonSerializableFactory;

public class ServerSessionPoolLoader
extends ServiceMBeanSupport
implements ServerSessionPoolLoaderMBean {
    private ServerSessionPoolFactory poolFactory;
    private String name;
    private String poolFactoryClass;
    private ObjectName xidFactory;

    public void setPoolName(String name) {
        this.name = name;
    }

    public String getPoolName() {
        return this.name;
    }

    public void setPoolFactoryClass(String classname) {
        this.poolFactoryClass = classname;
    }

    public String getPoolFactoryClass() {
        return this.poolFactoryClass;
    }

    public ObjectName getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(ObjectName xidFactory) {
        this.xidFactory = xidFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        XidFactoryMBean xidFactoryObj = (XidFactoryMBean)this.getServer().getAttribute(this.xidFactory, "Instance");
        Class<?> cls = Class.forName(this.poolFactoryClass);
        this.poolFactory = (ServerSessionPoolFactory)cls.newInstance();
        this.poolFactory.setName(this.name);
        this.poolFactory.setXidFactory(xidFactoryObj);
        this.log.debug((Object)("initialized with pool factory: " + this.poolFactory));
        InitialContext ctx = new InitialContext();
        String name = this.poolFactory.getName();
        String jndiname = "java:/" + name;
        try {
            NonSerializableFactory.rebind((Context)ctx, (String)jndiname, (Object)this.poolFactory);
            this.log.debug((Object)("pool factory " + name + " bound to " + jndiname));
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            String name = this.poolFactory.getName();
            String jndiname = "java:/" + name;
            ctx.unbind(jndiname);
            NonSerializableFactory.unbind((String)jndiname);
            this.log.debug((Object)("pool factory " + name + " unbound from " + jndiname));
        }
        catch (NamingException ignore) {
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }
}

