/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.ejb.EjbUtil;
import org.jboss.metadata.ClientMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.metadata.serviceref.ServiceRefDelegate;
import org.jboss.util.naming.Util;
import org.jboss.wsf.common.URLLoaderAdapter;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
import org.w3c.dom.Element;

public class ClientDeployer
extends SubDeployerSupport {
    protected void startService() throws Exception {
        super.startService();
    }

    protected void stopService() throws Exception {
        super.stopService();
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.getFile();
        if (!urlStr.endsWith(".jar") && !urlStr.endsWith(".jar/")) {
            return false;
        }
        boolean accepts = false;
        try {
            URL dd = di.localCl.findResource("META-INF/application-client.xml");
            if (dd != null) {
                this.log.debug((Object)("Found a META-INF/application-client.xml file, di: " + di));
                accepts = true;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return accepts;
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        super.create(di);
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        ClientMetaData metaData = null;
        try {
            InputStream in = null;
            if (di.alternativeDD == null) {
                in = di.localCl.getResourceAsStream("META-INF/application-client.xml");
            } else {
                String contentsDir = new File(di.url.getPath()).getParent();
                in = new FileInputStream(contentsDir + "/" + di.alternativeDD);
            }
            if (in == null) {
                throw new DeploymentException("No META-INF/application-client.xml found");
            }
            metaData = null;
            XmlFileLoader xfl = new XmlFileLoader(true);
            Element appClient = xfl.getDocument(in, "META-INF/application-client.xml").getDocumentElement();
            in.close();
            metaData = new ClientMetaData();
            metaData.setResourceClassLoader(di.localCl);
            metaData.importClientXml(appClient);
            di.metaData = metaData;
            in = di.localCl.getResourceAsStream("META-INF/jboss-client.xml");
            if (in != null) {
                xfl = new XmlFileLoader(true);
                Element jbossClient = xfl.getDocument(in, "META-INF/jboss-client.xml").getDocumentElement();
                in.close();
                metaData.importJbossClientXml(jbossClient);
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to parse metadata", (Throwable)e);
        }
        try {
            this.setupEnvironment(di, metaData);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to setup client ENC", (Throwable)e);
        }
        super.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        ClientMetaData metaData = (ClientMetaData)di.metaData;
        if (metaData != null) {
            String appClientName = metaData.getJndiName();
            this.log.info((Object)("Removing client ENC from: " + appClientName));
            try {
                InitialContext iniCtx = new InitialContext();
                Util.unbind((Context)iniCtx, (String)appClientName);
            }
            catch (NamingException e) {
                throw new DeploymentException("Failed to remove client ENC", (Throwable)e);
            }
        }
        super.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        super.destroy(di);
    }

    private void setupEnvironment(DeploymentInfo di, ClientMetaData metaData) throws Exception {
        String refName;
        String appClientName = metaData.getJndiName();
        InitialContext iniCtx = new InitialContext();
        Context envCtx = Util.createSubcontext((Context)iniCtx, (String)appClientName);
        this.log.debug((Object)("Creating client ENC binding under: " + appClientName));
        for (EnvEntryMetaData entry : metaData.getEnvironmentEntries()) {
            this.log.debug((Object)("Binding env-entry: " + entry.getName() + " of type: " + entry.getType() + " to value:" + entry.getValue()));
            EnvEntryMetaData.bindEnvEntry(envCtx, entry);
        }
        HashMap ejbRefs = metaData.getEjbReferences();
        for (EjbRefMetaData ref : ejbRefs.values()) {
            this.log.debug((Object)("Binding an EJBReference " + ref.getName()));
            if (ref.getLink() != null) {
                String linkName = ref.getLink();
                String jndiName = EjbUtil.findEjbLink(this.server, di, linkName);
                this.log.debug((Object)("Binding " + ref.getName() + " to ejb-link: " + linkName + " -> " + jndiName));
                if (jndiName == null) {
                    String msg = "Failed to resolve ejb-link: " + linkName + " make by ejb-name: " + ref.getName();
                    throw new DeploymentException(msg);
                }
                this.log.debug((Object)("Link resolved to:" + jndiName));
                Util.bind((Context)envCtx, (String)ref.getName(), (Object)new LinkRef(jndiName));
                continue;
            }
            if (ref.getJndiName() == null) {
                throw new DeploymentException("ejb-ref " + ref.getName() + ", expected either ejb-link in ejb-jar.xml " + "or jndi-name in jboss.xml");
            }
            this.log.debug((Object)("Binding " + ref.getName() + " to : " + ref.getJndiName()));
            Util.bind((Context)envCtx, (String)ref.getName(), (Object)new LinkRef(ref.getJndiName()));
        }
        URLLoaderAdapter vfsRoot = new URLLoaderAdapter(di.url);
        for (ServiceRefMetaData sref : metaData.getServiceReferences().values()) {
            refName = sref.getServiceRefName();
            new ServiceRefDelegate().bindServiceRef(envCtx, refName, (UnifiedVirtualFile)vfsRoot, (ClassLoader)di.ucl, sref);
        }
        HashMap resRefs = metaData.getResourceReferences();
        for (ResourceRefMetaData ref : resRefs.values()) {
            refName = ref.getRefName();
            String jndiName = ref.getJndiName();
            if (ref.getType().equals("java.net.URL")) {
                String resURL = ref.getResURL();
                if (resURL != null) {
                    this.log.debug((Object)("Binding '" + refName + "' to URL: " + resURL));
                    URL url = new URL(resURL);
                    Util.bind((Context)envCtx, (String)refName, (Object)url);
                    continue;
                }
                this.log.debug((Object)("Linking '" + refName + "' to URL: " + resURL));
                LinkRef urlLink = new LinkRef(jndiName);
                Util.bind((Context)envCtx, (String)refName, (Object)urlLink);
                continue;
            }
            this.log.debug((Object)("Binding resource: " + refName + " to JDNI as: " + jndiName));
            Util.bind((Context)envCtx, (String)refName, (Object)new LinkRef(jndiName));
        }
        HashMap envRefs = metaData.getResourceEnvReferences();
        for (ResourceEnvRefMetaData resRef : envRefs.values()) {
            String encName = resRef.getRefName();
            String jndiName = resRef.getJndiName();
            this.log.debug((Object)("Binding env resource: " + encName + " to JDNI as: " + jndiName));
            Util.bind((Context)envCtx, (String)encName, (Object)new LinkRef(jndiName));
        }
        this.log.info((Object)("Client ENC bound under: " + appClientName));
    }
}

