/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.UtilEvalError;

class ClassNameSpace
extends NameSpace {
    public static final int CLASS = 1;
    public static final int INSTANCE = 2;
    int type;

    public ClassNameSpace(NameSpace nameSpace, String string, int n) throws EvalError {
        super(nameSpace, string);
        this.type = n;
    }

    public void setVariable(String string, Object object, boolean bl) throws UtilEvalError {
        if (this.isClassInstance()) {
            boolean bl2 = false;
            super.setVariable(string, object, bl, bl2);
        }
        super.setVariable(string, object, bl);
    }

    protected boolean isVisible(NameSpace.Variable variable) throws UtilEvalError {
        if (this.isClass() && variable != null && !variable.hasModifier("static")) {
            throw new UtilEvalError("Can't reach instance var: " + variable.name + " from static context: " + this);
        }
        return !this.isClassInstance() || variable == null || !variable.hasModifier("static");
    }

    protected boolean isVisible(BshMethod bshMethod) throws UtilEvalError {
        String string = null;
        if (bshMethod != null) {
            string = bshMethod.getName();
        }
        if (this.isClass() && bshMethod != null && !bshMethod.hasModifier("static") && !string.equals("_bshClassInit") && !this.nsName.equals(string)) {
            throw new UtilEvalError("Can't reach instance method: " + string + " from static context: " + this);
        }
        return !this.isClassInstance() || bshMethod == null || !bshMethod.hasModifier("static");
    }

    public boolean isClassInstance() {
        return this.type == 2;
    }

    public boolean isClass() {
        return this.type == 1;
    }

    public This constructClassInstance(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        Object object;
        ClassNameSpace classNameSpace = this;
        String string = classNameSpace.getName();
        BshMethod bshMethod = null;
        try {
            bshMethod = classNameSpace.getMethod("_bshClassInit", new Class[0]);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Error getting default constructor", simpleNode, callStack);
        }
        if (bshMethod == null) {
            throw new EvalError("Unable to find initializer for class.", simpleNode, callStack);
        }
        Class[] classArray = Reflect.getTypes(objectArray);
        BshMethod bshMethod2 = null;
        try {
            bshMethod2 = classNameSpace.getMethod(string, classArray);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Error getting constructor", simpleNode, callStack);
        }
        if (bshMethod2 == null) {
            if (objectArray.length > 0) {
                throw new EvalError("Constructor not found: " + StringUtil.methodString(string, classArray), simpleNode, callStack);
            }
            object = classNameSpace.getMethods();
            for (int i = 0; i < ((BshMethod[])object).length; ++i) {
                if (!object[i].getName().equals(string)) continue;
                throw new EvalError("Default (no args) constructor not found: " + StringUtil.methodString(string, classArray), simpleNode, callStack);
            }
        }
        object = null;
        if (classNameSpace.getParent() instanceof ClassNameSpace && ((ClassNameSpace)classNameSpace.getParent()).isClass()) {
            This this_ = ((ClassNameSpace)classNameSpace.getParent()).constructClassInstance(new Object[0], interpreter, callStack, simpleNode);
            object = this_.getNameSpace();
        }
        ClassNameSpace classNameSpace2 = object != null ? new ClassNameSpace((NameSpace)object, string, 2) : new ClassNameSpace((NameSpace)classNameSpace, string, 2);
        callStack.push(classNameSpace2);
        try {
            bshMethod.invoke(new Object[0], interpreter, callStack, simpleNode, true);
        }
        catch (EvalError evalError) {
            evalError.reThrow("Exception in default constructor: " + evalError);
        }
        if (bshMethod2 != null) {
            try {
                bshMethod2.invoke(objectArray, interpreter, callStack, simpleNode, true);
            }
            catch (EvalError evalError) {
                evalError.reThrow("Exception in constructor: " + evalError);
            }
        }
        callStack.pop();
        This this_ = classNameSpace2.getThis(interpreter);
        return this_;
    }

    protected void checkVariableModifiers(String string, Modifiers modifiers) throws UtilEvalError {
    }

    protected void checkMethodModifiers(BshMethod bshMethod) throws UtilEvalError {
    }

    public String toString() {
        return "Scripted Class " + (this.isClassInstance() ? "Instance " : "") + " : " + super.toString();
    }

    public static boolean isScriptedClass(Object object) {
        return object instanceof This && ((This)object).getNameSpace() instanceof ClassNameSpace && ((ClassNameSpace)((This)object).getNameSpace()).isClass();
    }
}

