/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.Calendar;
import org.jboss.ws.extensions.security.FailedCheckException;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.w3c.dom.Document;

public class TimestampVerificationOperation {
    private Calendar now = null;

    public TimestampVerificationOperation() {
    }

    public TimestampVerificationOperation(Calendar now) {
        this.now = now;
    }

    public void process(Document message, Timestamp timestamp) throws WSSecurityException {
        Calendar now;
        Calendar expired = timestamp.getExpires();
        Calendar created = timestamp.getCreated();
        Calendar calendar = now = this.now == null ? Calendar.getInstance() : this.now;
        if (created.after(now)) {
            throw new WSSecurityException("Invalid timestamp, message claimed to be created after now");
        }
        if (expired != null && !now.before(expired)) {
            throw new FailedCheckException("Expired message.");
        }
    }
}

