/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.File;
import org.eclipse.core.internal.indexing.Index;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStore;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class IndexedStoreWrapper {
    private IndexedStore store;
    private IPath location;
    private static final String INDEX_NAME = "index";

    public IndexedStoreWrapper(IPath location) {
        this.location = location;
    }

    private void open() throws CoreException {
        try {
            String name = this.location.toOSString();
            this.store = IndexedStore.find(name);
            if (this.store == null) {
                this.store = new IndexedStore();
                this.store.open(name);
            }
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotOpen, (Object)this.location.toOSString());
            ResourceStatus status = new ResourceStatus(272, this.location, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void recreate() throws CoreException {
        this.close();
        File file = this.location.toFile();
        file.renameTo(this.location.addFileExtension("001").toFile());
        file.delete();
        if (!file.exists()) {
            try {
                this.open();
            }
            catch (CoreException e) {
                this.store = null;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() {
        if (this.store == null) {
            return;
        }
        try {
            try {
                this.store.close();
            }
            catch (Exception e) {
                String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotClose, (Object)this.location.toOSString());
                ResourceStatus status = new ResourceStatus(272, this.location, message, (Throwable)e);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.store = null;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.store = null;
            return;
        }
    }

    public synchronized void commit() throws CoreException {
        if (this.store == null) {
            return;
        }
        try {
            this.store.commit();
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotCommit, (Object)this.location.toOSString());
            ResourceStatus status = new ResourceStatus(272, this.location, message, (Throwable)e);
            throw new ResourceException((IStatus)status);
        }
    }

    private void create() throws CoreException {
        block2: {
            try {
                this.open();
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                this.recreate();
                if (this.store != null) break block2;
                String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotCreate, (Object)this.location.toOSString());
                ResourceStatus status = new ResourceStatus(272, this.location, message, null);
                throw new ResourceException((IStatus)status);
            }
        }
    }

    private Index createIndex() throws CoreException {
        try {
            return this.getStore().createIndex(INDEX_NAME);
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotCreateIndex, (Object)this.location.toOSString());
            ResourceStatus status = new ResourceStatus(272, this.location, message, (Throwable)e);
            throw new ResourceException((IStatus)status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Index getIndex() throws CoreException {
        Exception problem = null;
        try {
            try {
                Index index = this.getStore().getIndex(INDEX_NAME);
                Object var3_6 = null;
                if (problem == null) return index;
            }
            catch (IndexedStoreException e) {
                if (e.id == 11) {
                    Index index = this.createIndex();
                    Object var3_7 = null;
                    if (problem == null) return index;
                    String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotGetIndex, (Object)this.location.toOSString());
                    ResourceStatus status = new ResourceStatus(271, this.location, message, (Throwable)problem);
                    throw new ResourceException((IStatus)status);
                }
                problem = e;
                Index index = null;
                Object var3_8 = null;
                if (problem == null) return index;
                String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotGetIndex, (Object)this.location.toOSString());
                ResourceStatus status = new ResourceStatus(271, this.location, message, (Throwable)problem);
                throw new ResourceException((IStatus)status);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                problem = e;
                Index index = null;
                Object var3_9 = null;
                if (problem == null) return index;
                String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotGetIndex, (Object)this.location.toOSString());
                ResourceStatus status = new ResourceStatus(271, this.location, message, (Throwable)problem);
                throw new ResourceException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var3_10 = null;
            if (problem != null) {
                String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotGetIndex, (Object)this.location.toOSString());
                ResourceStatus status = new ResourceStatus(271, this.location, message, (Throwable)problem);
                throw new ResourceException((IStatus)status);
            }
            throw throwable;
        }
        String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotGetIndex, (Object)this.location.toOSString());
        ResourceStatus status = new ResourceStatus(271, this.location, message, (Throwable)problem);
        throw new ResourceException((IStatus)status);
    }

    public synchronized String getObjectAsString(ObjectID id) throws CoreException {
        try {
            return this.getStore().getObjectAsString(id);
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotRead, (Object)this.location.toOSString());
            throw new ResourceException(271, this.location, message, (Throwable)e);
        }
    }

    private IndexedStore getStore() throws CoreException {
        if (this.store == null) {
            this.create();
        }
        return this.store;
    }

    public synchronized IndexCursor getCursor() throws CoreException {
        try {
            return this.getIndex().open();
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotCreateCursor, (Object)this.location.toOSString());
            throw new ResourceException(271, this.location, message, (Throwable)e);
        }
    }

    public synchronized ObjectID createObject(String s) throws CoreException {
        try {
            return this.getStore().createObject(s);
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotWrite, (Object)this.location.toOSString());
            throw new ResourceException(272, this.location, message, (Throwable)e);
        }
    }

    public synchronized ObjectID createObject(byte[] b) throws CoreException {
        try {
            return this.getStore().createObject(b);
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotWrite, (Object)this.location.toOSString());
            throw new ResourceException(272, this.location, message, (Throwable)e);
        }
    }

    public synchronized void removeObject(ObjectID id) throws CoreException {
        try {
            this.getStore().removeObject(id);
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotDelete, (Object)this.location.toOSString());
            throw new ResourceException(273, this.location, message, (Throwable)e);
        }
    }

    public synchronized byte[] getObject(ObjectID id) throws CoreException {
        try {
            return this.getStore().getObject(id);
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.indexed_couldNotRead, (Object)this.location.toOSString());
            throw new ResourceException(271, this.location, message, (Throwable)e);
        }
    }

    public synchronized void reset() {
        try {
            this.recreate();
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }
}

