/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;

public class TarLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private TarFile tarFile;
    private TarEntry root = new TarEntry("/");
    private Map children;
    private Map directoryEntryCache = new HashMap();
    private int stripLevel;

    public TarLeveledStructureProvider(TarFile sourceFile) {
        this.tarFile = sourceFile;
        this.root.setFileType(53);
    }

    protected void addToChildren(TarEntry parent, TarEntry child) {
        ArrayList<TarEntry> childList = (ArrayList<TarEntry>)this.children.get(parent);
        if (childList == null) {
            childList = new ArrayList<TarEntry>();
            this.children.put(parent, childList);
        }
        childList.add(child);
    }

    protected void createContainer(IPath pathname) {
        if (this.directoryEntryCache.containsKey(pathname)) {
            return;
        }
        TarEntry parent = pathname.segmentCount() == 1 ? this.root : (TarEntry)this.directoryEntryCache.get(pathname.removeLastSegments(1));
        TarEntry newEntry = new TarEntry(pathname.toString());
        newEntry.setFileType(53);
        this.directoryEntryCache.put(pathname, newEntry);
        this.addToChildren(parent, newEntry);
    }

    protected void createFile(TarEntry entry) {
        Path pathname = new Path(entry.getName());
        TarEntry parent = pathname.segmentCount() == 1 ? this.root : (TarEntry)this.directoryEntryCache.get(pathname.removeLastSegments(1));
        this.addToChildren(parent, entry);
    }

    public List getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return (List)this.children.get(element);
    }

    public InputStream getContents(Object element) {
        try {
            return this.tarFile.getInputStream((TarEntry)element);
        }
        catch (TarException tarException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ResourceAttributes getResourceAttributes(Object element) {
        ResourceAttributes attributes = new ResourceAttributes();
        TarEntry entry = (TarEntry)element;
        attributes.setExecutable((entry.getMode() & 0x40L) != 0L);
        attributes.setReadOnly((entry.getMode() & 0x80L) == 0L);
        return attributes;
    }

    public String getFullPath(Object element) {
        return this.stripPath(((TarEntry)element).getName());
    }

    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((TarEntry)element).getName();
        }
        return this.stripPath(new Path(((TarEntry)element).getName()).lastSegment());
    }

    public Object getRoot() {
        return this.root;
    }

    public TarFile getTarFile() {
        return this.tarFile;
    }

    protected void initialize() {
        this.children = new HashMap(1000);
        Enumeration entries = this.tarFile.entries();
        while (entries.hasMoreElements()) {
            TarEntry entry = (TarEntry)entries.nextElement();
            if (entry.getFileType() != 48) continue;
            IPath path = new Path(entry.getName()).addTrailingSeparator();
            int pathSegmentCount = path.segmentCount();
            int i = 1;
            while (i < pathSegmentCount) {
                this.createContainer(path.uptoSegment(i));
                ++i;
            }
            this.createFile(entry);
        }
    }

    public boolean isFolder(Object element) {
        return ((TarEntry)element).getFileType() == 53;
    }

    private String stripPath(String path) {
        String pathOrig = new String(path);
        int i = 0;
        while (i < this.stripLevel) {
            int firstSep = path.indexOf(47);
            if (firstSep == 0) {
                path = path.substring(1);
                firstSep = path.indexOf(47);
            }
            if (firstSep == -1) {
                return pathOrig;
            }
            path = path.substring(firstSep);
            ++i;
        }
        return path;
    }

    public void setStrip(int level) {
        this.stripLevel = level;
    }

    public int getStrip() {
        return this.stripLevel;
    }
}

